package cn.ibizlab.util.client;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import java.util.Map;

@FeignClient(value = "ibzuaa",fallback = IBZUAAFallback.class)
public interface IBZUAAFeignClient
{

	/**
	 * 从uaa中获取当前用户权限
	 * @param loginName
	 * @param systemId
	 * @return
	 */
	@GetMapping(value = "/uaa/permission/{loginname}")
    JSONObject getUserPermissionData(@PathVariable("loginname") String loginName, @RequestParam("systemid") String systemId);

	/**
	 * 推送系统权限数据到uaa
	 * @param systemPermissionData
	 * @param systemId
	 * @return
	 */
	@PostMapping("/uaa/permission/save")
	Map<String,Object> pushSystemPermissionData(@RequestBody Map<String, Object> systemPermissionData,  @RequestParam("systemid") String systemId);

}
