package cn.ibizlab.util.client;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

@FeignClient(value = "ibzou",fallback = IBZOUFallback.class)
public interface IBZOUFeignClient
{

	/**
	 * 从ou中获取当前上下级组织、部门信息
	 * @param loginName 登录名
	 * @return
	 */
	@GetMapping(value = "/ibzou/org/{loginname}")
	JSONObject getOrgInfo(@PathVariable("loginname") String loginName);
}
