import AuthService from '../auth-service';

/**
 * 部门权限服务对象基类
 *
 * @export
 * @class IBZDepartmentAuthServiceBase
 * @extends {AuthService}
 */
export default class IBZDepartmentAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  IBZDepartmentAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  IBZDepartmentAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof IBZDepartmentAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}