import AuthService from '../auth-service';

/**
 * 绑定消息账号权限服务对象基类
 *
 * @export
 * @class MsgUserAccountAuthServiceBase
 * @extends {AuthService}
 */
export default class MsgUserAccountAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  MsgUserAccountAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  MsgUserAccountAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof MsgUserAccountAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = this.getSysOPPrivs();
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}