package cn.ibizlab.api.rest.extensions;

import cn.ibizlab.core.extensions.domain.Msg;
import cn.ibizlab.core.extensions.domain.Template;
import cn.ibizlab.core.extensions.service.NotifyCoreService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@RestController
public class NotifyCoreResource {

    @Autowired
    NotifyCoreService notifyCoreService;

    /**
     * 发送工作流消息
     * @param msg
     * @return
     */
    @RequestMapping(method = RequestMethod.POST,value = "/SendMsg")
    public ResponseEntity<Boolean> SendMsg(@Validated @RequestBody Msg msg){
        return ResponseEntity.status(HttpStatus.OK).body(notifyCoreService.sendMsg(msg));
    }
    /**
     * 建立消息模板
     * @param template
     * @return
     */
    @RequestMapping(method = RequestMethod.POST,value = "/createMsgTemplate")
    public ResponseEntity<Boolean> createMsgTemplate(@Validated @RequestBody Template template){
        return ResponseEntity.status(HttpStatus.OK).body(notifyCoreService.createMsgTemplate(template));
    }
    /**
     * 发送钉钉链接消息
     * @param msg
     * @return
     */
    @RequestMapping(method = RequestMethod.POST,value = "/dingtalk/sendlinkmsg")
    public ResponseEntity<Long> sendDingTalkLinkMsg(@RequestBody Msg msg){
        return ResponseEntity.status(HttpStatus.OK).body(notifyCoreService.sendLinkMsg(msg));
    }
    /**
     * 创建钉钉待办
     * @param msg
     * @return
     */
    @RequestMapping(method = RequestMethod.POST,value = "/dingtalk/createworkrecord")
    public ResponseEntity<Boolean> createDingTalkWorkRecord(@RequestBody Msg msg){
        return ResponseEntity.status(HttpStatus.OK).body(notifyCoreService.createWorkRecord(msg));
    }
    /**
     * 完成钉钉待办
     * @param msg
     * @return
     */
    @RequestMapping(method = RequestMethod.POST,value = "/dingtalk/finishworkrecord")
    public ResponseEntity<Boolean> finishDingTalkWorkRecord(@RequestBody Msg msg){
        return ResponseEntity.status(HttpStatus.OK).body(notifyCoreService.finishWorkRecord(msg));
    }

}
