/**
 * LiteIndex 部件模型
 *
 * @export
 * @class LiteIndexModel
 */
export default class LiteIndexModel {

    /**
     * 菜单项集合
     *
     * @public
     * @type {any[]}
     * @memberof LiteIndexModel
     */
    public items: any[] = [
        {
	id: '4B9A341A-0A50-4997-84D8-16FA43CDED10',
	name: 'menuitem2',
	text: '数据源',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '数据源',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc2',
	resourcetag: '',
	authtag:'web-liteIndex-menuitem2',
},
        {
	id: '4F6D513C-830B-4920-8D21-C7241EBC417D',
	name: 'menuitem1',
	text: '实体',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc',
	resourcetag: '',
	authtag:'web-liteIndex-menuitem1',
},
        {
	id: 'E7008324-F31D-4CB7-B2E6-F3CE660996B0',
	name: 'menuitem3',
	text: '视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc3',
	resourcetag: '',
	authtag:'web-liteIndex-menuitem3',
},
        {
	id: '7B655FD1-69E0-4A81-9618-87B5F60DCB12',
	name: 'menuitem4',
	text: '组件',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '组件',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc4',
	resourcetag: '',
	authtag:'web-liteIndex-menuitem4',
},
    ];

	/**
	 * 应用功能集合
	 *
	 * @public
	 * @type {any[]}
	 * @memberof LiteIndexModel
	 */
	public funcs: any[] = [
        {
            appfunctag: 'AppFunc4',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'dstcomponentgridview',
            deResParameters: [],
            routepath: '/liteindex/:liteindex?/dstcomponents/:dstcomponent?/gridview/:gridview?',
            parameters: [
                { pathName: 'dstcomponents', parameterName: 'dstcomponent' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'AppFunc',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'metaentitygridview',
            deResParameters: [],
            routepath: '/liteindex/:liteindex?/metaentities/:metaentity?/gridview/:gridview?',
            parameters: [
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'AppFunc2',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'dstdatasourcegridview',
            deResParameters: [],
            routepath: '/liteindex/:liteindex?/dstdatasources/:dstdatasource?/gridview/:gridview?',
            parameters: [
                { pathName: 'dstdatasources', parameterName: 'dstdatasource' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'AppFunc3',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'dstviewgridview',
            deResParameters: [],
            routepath: '/liteindex/:liteindex?/dstviews/:dstview?/gridview/:gridview?',
            parameters: [
                { pathName: 'dstviews', parameterName: 'dstview' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
	];

    /**
     * 获取所有菜单项集合
     *
     * @returns {any[]}
     * @memberof LiteIndexModel
     */
    public getAppMenuItems(): any[] {
        return this.items;
    }

    /**
     * 获取所有应用功能集合
     *
     * @returns {any[]}
     * @memberof LiteIndexModel
     */
    public getAppFuncs(): any[] {
        return this.funcs;
    }
}