package cn.ibizlab.api.rest.extensions;

import cn.ibizlab.core.extensions.service.DynamicModelConfigExService;
import cn.ibizlab.core.lite.domain.*;
import cn.ibizlab.core.lite.extensions.domain.*;
import cn.ibizlab.core.lite.extensions.model.DataModel;
import cn.ibizlab.core.lite.extensions.model.Property;
import cn.ibizlab.core.lite.extensions.service.DbEntityService;
import cn.ibizlab.core.lite.extensions.service.LiteCoreService;
import cn.ibizlab.core.lite.extensions.service.LiteDataService;
import cn.ibizlab.core.lite.extensions.service.LiteModelService;
import cn.ibizlab.core.lite.filter.MetaFieldSearchContext;
import cn.ibizlab.core.lite.service.IDstComponentService;
import cn.ibizlab.core.lite.service.IDstConfigService;
import cn.ibizlab.core.lite.service.IMetaEntityService;
import cn.ibizlab.core.lite.service.IMetaFieldService;
import cn.ibizlab.util.client.IBZDictFeignClient;
import cn.ibizlab.util.dict.CodeItem;
import cn.ibizlab.util.dict.CodeList;
import cn.ibizlab.util.dict.Option;
import cn.ibizlab.util.errors.BadRequestAlertException;
import cn.ibizlab.util.helper.DataObject;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Slf4j
@Api(tags = {"接口" })
@RestController("api-litecore")
@RequestMapping("")
public class LiteCoreResource {

    @Autowired
    private LiteModelService liteModelService;

    @Autowired
    private IDstComponentService dstComponentService;

    @Autowired
    @Lazy
    LiteCoreService liteCoreService;

    @Autowired
    IMetaEntityService metaEntityService;

    @Autowired
    private LiteDataService liteDataService;

    @Autowired
    private DbEntityService dbEntityService;

    @RequestMapping(method = RequestMethod.GET, value = "/dst/test/{modelid}/data/{key}")
    public ResponseEntity<ModelObj> getstr(@PathVariable(name="modelid",required = false) String modelid,@PathVariable(name="key",required = false) String key)
    {

        if(StringUtils.isEmpty(modelid))
            modelid="dataModelff8080816a8b510c016a8c2f18b10001";
        return ResponseEntity.ok(liteDataService.getModelObjs(modelid, null,key));
    }

    @Autowired
    @Lazy
    private IMetaFieldService fieldService;

    @RequestMapping(method = RequestMethod.GET, value = "/lite/{system}/{from}.ibzbak")
    public ResponseEntity<JSONObject> ibzbak(@PathVariable(name="system",required = true) String system,@PathVariable(name="from",required = true) String from)
    {
        MetaFieldSearchContext context=new MetaFieldSearchContext();
        context.setSize(Integer.MAX_VALUE);
        context.setN_systemid_eq(system);
        context.getSearchCond().ge("updatedate", DataObject.getTimestampValue(from, null));
        JSONArray jArray = new JSONArray();
        fieldService.searchDefault(context).getContent().forEach(sx->{
            JSONObject json = new JSONObject();
            JSONObject jo = new JSONObject();

            jo.put("psdefieldname", sx.getFieldName());
            jo.put("predefinetype", sx.getPredefined());
            jo.put("unionkeyvalue", sx.getUnionKey());
            jo.put("codename", sx.getCodeName());
           
            jo.put("physicalfield", sx.getPhysicalField());
            jo.put("psdeid", DigestUtils.md5DigestAsHex(("2C40DFCD-0DF5-47BF-91A5-C45F810B0001||"+sx.getEntityName()).getBytes()).toLowerCase());
            jo.put("logicname", sx.getFieldLogicName());
            if (sx.getDataLength() != null && sx.getDataLength() > 0)
                jo.put("length", sx.getDataLength());
            if (sx.getDataPreci() != null && sx.getDataPreci() > 0)
                jo.put("precision2", sx.getDataPreci());
            jo.put("ordervalue", sx.getShowOrder());
            jo.put("psdefieldid", DigestUtils.md5DigestAsHex((DigestUtils.md5DigestAsHex(("2C40DFCD-0DF5-47BF-91A5-C45F810B0001||"+sx.getEntityName()).getBytes()).toLowerCase()+"||"+sx.getFieldName()).getBytes()).toLowerCase());
            if(1==sx.getPhysicalField()&&(StringUtils.isEmpty(sx.getExpression())))
                jo.put("deftype", 1);
            else {
                jo.put("deftype", 2);
                jo.put("formulaformat",sx.getExpression());
            }
            jo.put("pkey", sx.getKeyField());
            jo.put("pssystemid", "2C40DFCD-0DF5-47BF-91A5-C45F810B0001");
            jo.put("psdename", sx.getEntityName());
            jo.put("tablename", sx.getEntityName());

            String strRT = "文本，可指定长度";
            String strDataTypeId=sx.getFieldType();
            jo.put("psdatatypeid", strDataTypeId);
            if (strDataTypeId.equalsIgnoreCase("DECIMAL"))
                strRT = "数值";
            else if (strDataTypeId.equalsIgnoreCase("INT"))
                strRT = "整型";
            else if (strDataTypeId.equalsIgnoreCase("BIGDECIMAL"))
                strRT = "大数值";
            else if (strDataTypeId.equalsIgnoreCase("BIGINT"))
                strRT = "大整型";
            else if (strDataTypeId.equalsIgnoreCase("LONGTEXT"))
                strRT = "长文本，没有长度限制";
            else if (strDataTypeId.equalsIgnoreCase("LONGTEXT_1000"))
                strRT = "长文本，长度1000";    
            else if (strDataTypeId.equalsIgnoreCase("DATE"))
                strRT = "日期型";
            else if (strDataTypeId.equalsIgnoreCase("DATETIME"))
                strRT = "日期时间型";
            
            jo.put("psdatatypename", strRT);
            jo.put("allowempty", sx.getNullable());
            json.put("srfvalue", jo);
            json.put("srfdeid", "42d91505b9bb15b9900b4298fcca9915");
            json.put("srfdename", "PSDEFIELD");
            jArray.add(json);
        });
        JSONObject jo = new JSONObject();
		jo.put("items", jArray);
        
        return ResponseEntity.ok(jo);
    }

     

    @RequestMapping(method = RequestMethod.GET, value = {"/lite/datamodels/{modelid}","/lite/datamodels/{modelid}/name/{modelname}"})
    public ResponseEntity<DataModel> getDataModel(@PathVariable(name="modelid") String modelid,
                                                  @PathVariable(name="modelname",required = false) String modelname)
    {
        return ResponseEntity.ok(liteModelService.getDataModel(modelid,modelname));
    }

    @RequestMapping(method = RequestMethod.GET, value = {"/lite/datamodels/{modelid}/submodels","/lite/datamodels/{modelid}/name/{modelname}/submodels"})
    public ResponseEntity<List<Option>> getDataModelSubModels(@PathVariable(name="modelid") String modelid,
                                                              @PathVariable(name="modelname",required = false) String modelname)
    {
        List<Option> list =  new ArrayList<>();
        liteModelService.getDataModel(modelid,modelname).getSubDataModel().forEach(dataModel -> list.add(new Option().setId(dataModel.getDataModelName()).setLabel(dataModel.getFactPorperty().getEntityModel().getLogicName()+"["+dataModel.getDataModelName()+"]")));
        return ResponseEntity.ok(list);
    }

    @RequestMapping(method = RequestMethod.GET, value = {"/lite/datamodels/{modelid}/propertys","/lite/datamodels/{modelid}/name/{modelname}/propertys"})
    public ResponseEntity<List<Option>> getDataModelParentProperty(@PathVariable(name="modelid") String modelid,
                                                                   @PathVariable(name="modelname",required = false) String modelname)
    {
        List<Option> list =  new ArrayList<>();
        liteModelService.getDataModel(modelid,modelname).getParentProperty().forEach(property -> {
            Option option = new Option().setId(property.getPropertyName()).setLabel(property.getEntityModel().getLogicName()+"["+property.getPropertyName()+"]");
            list.add(option);
        });
        return ResponseEntity.ok(list);
    }

    @RequestMapping(method = RequestMethod.GET, value = {"/lite/datamodels/{modelid}/propertys/{propertyname}/fields","/lite/datamodels/{modelid}/name/{modelname}/propertys/{propertyname}/fields"})
    public ResponseEntity<List<Option>> getDataModelParentField(@PathVariable(name="modelid") String modelid,
                                                                @PathVariable(name="modelname",required = false) String modelname,
                                                                @PathVariable(name="propertyname",required = false) String propertyname)
    {
        List<Option> list =  new ArrayList<>();
        Property property=liteModelService.getDataModel(modelid,modelname).findObjectProperty(propertyname,"UP");
        property.getEntityModel().getFields().forEach(field -> {
            Option option = new Option().setId(property.getPropertyName()+"."+field.getColumnName()).setLabel(field.getComment()+"["+field.getColumnName()+"]");
            list.add(option);
        });
        return ResponseEntity.ok(list);
    }

    @Autowired
    private IBZDictFeignClient dictFeignClient;

    @RequestMapping(method = RequestMethod.GET, value = {"/lite/datamodels/{modelid}/{propertyname}.{fieldname}/dict"})
    public ResponseEntity<List<CodeItem>> getDataModelFieldDict(@PathVariable(name="modelid") String modelid,
                                                                @PathVariable(name="propertyname",required = false) String propertyname,
                                                                @PathVariable(name="fieldname",required = false) String fieldname)
    {
        List<CodeItem> list =  new ArrayList<>();
        Property property=liteModelService.getDataModel(modelid).findObjectProperty(propertyname,"ALL");
        if(property!=null)
        {
            MetaField field=property.getEntityModel().getField(fieldname).getField();
            if(field!=null)
            {
                String dict = field.getDict();
                if(!StringUtils.isEmpty(dict))
                {
                    CodeList codeList=dictFeignClient.getCodeList(dict);
                    if(codeList!=null)
                        list=codeList.getOptions();

                }
            }

        }

        return ResponseEntity.ok(list);
    }

    @RequestMapping(method = RequestMethod.GET, value = "/lite/{system}/entitys")
    public ResponseEntity<List<EntityModel>> getEntityModel(@PathVariable("system") String system) {
        return ResponseEntity.status(HttpStatus.OK).body(liteModelService.getEntityModel(system));
    }



    @RequestMapping(method = RequestMethod.GET, value = "/lite/{system}/metaentitys")
    public ResponseEntity<List<MetaEntity>> getMetaEntitys(@PathVariable("system") String system) {
        return ResponseEntity.status(HttpStatus.OK).body(metaEntityService.list(Wrappers.<MetaEntity>lambdaQuery().eq(MetaEntity::getSystemId,system)));
    }

    @RequestMapping(method = RequestMethod.GET, value = "/lite/{system}/metafieles")
    public ResponseEntity<List<MetaField>> getFields(@PathVariable("system") String system) {
        MetaFieldSearchContext context=new MetaFieldSearchContext();
        context.setSize(Integer.MAX_VALUE);
        context.setN_systemid_eq(system);
        return ResponseEntity.status(HttpStatus.OK).body(fieldService.searchDefault(context).getContent());
    }

    @RequestMapping(method = RequestMethod.GET, value = "/lite/{system}/entitys/{entity}")
    public ResponseEntity<EntityModel> getEntityModel(@PathVariable("system") String system, @PathVariable("entity") String entity) {
        return ResponseEntity.status(HttpStatus.OK).body(liteModelService.getEntityModel(system,entity));
    }

    @RequestMapping(method = RequestMethod.GET, value = "/lite/{system}/entitys/{entity}/fields")
    public ResponseEntity<List<FieldModel>> getEntityModelFields(@PathVariable("system") String system, @PathVariable("entity") String entity) {
        return ResponseEntity.status(HttpStatus.OK).body(liteModelService.getEntityModel(system,entity).getFields());
    }

    @RequestMapping(method = RequestMethod.GET, value = "/lite/{system}/entitys/{entity}/references")
    public ResponseEntity<List<RelationshipModel>> getEntityModelReferences(@PathVariable("system") String system, @PathVariable("entity") String entity) {
        return ResponseEntity.status(HttpStatus.OK).body(liteModelService.getEntityModel(system,entity).getReferences());
    }

    @RequestMapping(method = RequestMethod.GET, value = "/lite/{system}/entitys/{entity}/nesteds")
    public ResponseEntity<List<RelationshipModel>> getEntityModelNesteds(@PathVariable("system") String system, @PathVariable("entity") String entity) {
        return ResponseEntity.status(HttpStatus.OK).body(liteModelService.getEntityModel(system,entity).getNesteds());
    }


    @RequestMapping(method = RequestMethod.GET, value = "/lite/{app}/components/{component}")
    public ResponseEntity<JSON> getComponent(@PathVariable("app") String app, @PathVariable("component") String component) {

        DstComponent dstComponent = liteCoreService.getComponent(app,component);

        return ResponseEntity.status(HttpStatus.OK).body(JSON.parseObject(dstComponent.getConfig()));
    }

    @ApiOperation(value = "保存系统", tags = {"系统" },  notes = "保存系统")
    @RequestMapping(method = RequestMethod.POST, value = "/lite/syncsysmodel")
    public ResponseEntity<Boolean> syncSysModel(@RequestBody SysModel sysModel) {
        return ResponseEntity.status(HttpStatus.OK).body(liteCoreService.syncSysModel(sysModel));
    }


    @RequestMapping(method = RequestMethod.GET, value = "/lite/sysapps")
    public ResponseEntity<List<DstSystem>> getSysApps() {
        return ResponseEntity.status(HttpStatus.OK).body(liteModelService.getSysApp());
    }


    @Autowired
    private IDstConfigService dstConfigService;


    @RequestMapping(method = RequestMethod.GET, value = { "/lite/mockdata/{configType}/{targetType}", "/lite/mockdata/{system}/{configType}/{targetType}","/lite/mockdata/{system}/{configType}/{targetType}/{userId}"})
    public ResponseEntity mockdata(@PathVariable(name = "system",required = false) String system,@PathVariable("configType") String configType, @PathVariable("targetType") String targetType,@PathVariable(name = "userId",required = false) String userId) {

        LambdaQueryWrapper<DstConfig> wrapper=Wrappers.lambdaQuery();
        if(!StringUtils.isEmpty(system))
            wrapper.eq(DstConfig::getSystemId,system);
        if(!StringUtils.isEmpty(userId))
            wrapper.eq(DstConfig::getUserId,userId);
        wrapper.eq(DstConfig::getCfgType,configType);
        wrapper.eq(DstConfig::getTargetType,targetType);
        DstConfig config=dstConfigService.getOne(wrapper,false);

        if(config==null)
            throw new BadRequestAlertException("未找到配置项","DstConfig",configType+"-"+targetType);

        return ResponseEntity.ok(JSON.parse(config.getCfg()));
    }

    @Autowired
    DynamicModelConfigExService dynamicModelService;

    @RequestMapping(method = RequestMethod.GET, value = "/lite/{systemid}/getdynamicmodel")
    public ResponseEntity<List<Map<String, Object>>> getDynamicModel(@PathVariable("systemid") String systemId){
        return ResponseEntity.status(HttpStatus.OK).body(dynamicModelService.getDynamicModel(systemId));
    }

}
