package cn.ibizlab.api.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[DstDataSourceDTO]
 */
@Data
public class DstDataSourceDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [DSID]
     *
     */
    @JSONField(name = "ds_id")
    @JsonProperty("ds_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String dsId;

    /**
     * 属性 [DSNAME]
     *
     */
    @JSONField(name = "ds_name")
    @JsonProperty("ds_name")
    @NotBlank(message = "[数据源名称]不允许为空!")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String dsName;

    /**
     * 属性 [DSTYPE]
     *
     */
    @JSONField(name = "ds_type")
    @JsonProperty("ds_type")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String dsType;

    /**
     * 属性 [DSCFG]
     *
     */
    @JSONField(name = "ds_cfg")
    @JsonProperty("ds_cfg")
    @Size(min = 0, max = 4000, message = "内容长度必须小于等于[4000]")
    private String dsCfg;


    /**
     * 设置 [DSNAME]
     */
    public void setDsName(String  dsName){
        this.dsName = dsName ;
        this.modify("dsname",dsName);
    }

    /**
     * 设置 [DSTYPE]
     */
    public void setDsType(String  dsType){
        this.dsType = dsType ;
        this.modify("dstype",dsType);
    }

    /**
     * 设置 [DSCFG]
     */
    public void setDsCfg(String  dsCfg){
        this.dsCfg = dsCfg ;
        this.modify("dscfg",dsCfg);
    }


}


