import { Http,Util,Errorlog } from '@/utils';
import ControlService from '@/widgets/control-service';
import LiteIndexModel from './lite-index-appmenu-model';


/**
 * LiteIndex 部件服务对象
 *
 * @export
 * @class LiteIndexService
 */
export default class LiteIndexService extends ControlService {

    /**
     * 设置从数据模式
     *
     * @type {boolean}
     * @memberof LiteIndexService
     */
    public setTempMode(){
        this.isTempMode = false;
    }

    /**
     * Creates an instance of LiteIndexService.
     * 
     * @param {*} [opts={}]
     * @memberof LiteIndexService
     */
    constructor(opts: any = {}) {
        super(opts);
        this.model = new LiteIndexModel();
    }

    /**
     * 获取数据
     *
     * @returns {Promise<any>}
     * @memberof LiteIndex
     */
    @Errorlog
    public get(params: any = {}): Promise<any> {
        return Http.getInstance().get('v7/lite-indexappmenu', params);
    }

}