package cn.ibizlab.api.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.api.dto.*;
import cn.ibizlab.api.mapping.*;
import cn.ibizlab.core.lite.domain.DstView;
import cn.ibizlab.core.lite.service.IDstViewService;
import cn.ibizlab.core.lite.filter.DstViewSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"页面" })
@RestController("api-dstview")
@RequestMapping("")
public class DstViewResource {

    @Autowired
    public IDstViewService dstviewService;

    @Autowired
    @Lazy
    public DstViewMapping dstviewMapping;

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-Create-all')")
    @ApiOperation(value = "新建页面", tags = {"页面" },  notes = "新建页面")
	@RequestMapping(method = RequestMethod.POST, value = "/dstviews")
    public ResponseEntity<DstViewDTO> create(@Validated @RequestBody DstViewDTO dstviewdto) {
        DstView domain = dstviewMapping.toDomain(dstviewdto);
		dstviewService.create(domain);
        DstViewDTO dto = dstviewMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-Create-all')")
    @ApiOperation(value = "批量新建页面", tags = {"页面" },  notes = "批量新建页面")
	@RequestMapping(method = RequestMethod.POST, value = "/dstviews/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<DstViewDTO> dstviewdtos) {
        dstviewService.createBatch(dstviewMapping.toDomain(dstviewdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "dstview" , versionfield = "updatedate")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-Update-all')")
    @ApiOperation(value = "更新页面", tags = {"页面" },  notes = "更新页面")
	@RequestMapping(method = RequestMethod.PUT, value = "/dstviews/{dstview_id}")
    public ResponseEntity<DstViewDTO> update(@PathVariable("dstview_id") String dstview_id, @RequestBody DstViewDTO dstviewdto) {
		DstView domain  = dstviewMapping.toDomain(dstviewdto);
        domain .setId(dstview_id);
		dstviewService.update(domain );
		DstViewDTO dto = dstviewMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-Update-all')")
    @ApiOperation(value = "批量更新页面", tags = {"页面" },  notes = "批量更新页面")
	@RequestMapping(method = RequestMethod.PUT, value = "/dstviews/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<DstViewDTO> dstviewdtos) {
        dstviewService.updateBatch(dstviewMapping.toDomain(dstviewdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-Remove-all')")
    @ApiOperation(value = "删除页面", tags = {"页面" },  notes = "删除页面")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dstviews/{dstview_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("dstview_id") String dstview_id) {
         return ResponseEntity.status(HttpStatus.OK).body(dstviewService.remove(dstview_id));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-Remove-all')")
    @ApiOperation(value = "批量删除页面", tags = {"页面" },  notes = "批量删除页面")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dstviews/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        dstviewService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-Get-all')")
    @ApiOperation(value = "获取页面", tags = {"页面" },  notes = "获取页面")
	@RequestMapping(method = RequestMethod.GET, value = "/dstviews/{dstview_id}")
    public ResponseEntity<DstViewDTO> get(@PathVariable("dstview_id") String dstview_id) {
        DstView domain = dstviewService.get(dstview_id);
        DstViewDTO dto = dstviewMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取页面草稿", tags = {"页面" },  notes = "获取页面草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/dstviews/getdraft")
    public ResponseEntity<DstViewDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(dstviewMapping.toDto(dstviewService.getDraft(new DstView())));
    }

    @ApiOperation(value = "检查页面", tags = {"页面" },  notes = "检查页面")
	@RequestMapping(method = RequestMethod.POST, value = "/dstviews/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody DstViewDTO dstviewdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(dstviewService.checkKey(dstviewMapping.toDomain(dstviewdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-Save-all')")
    @ApiOperation(value = "保存页面", tags = {"页面" },  notes = "保存页面")
	@RequestMapping(method = RequestMethod.POST, value = "/dstviews/save")
    public ResponseEntity<Boolean> save(@RequestBody DstViewDTO dstviewdto) {
        return ResponseEntity.status(HttpStatus.OK).body(dstviewService.save(dstviewMapping.toDomain(dstviewdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-Save-all')")
    @ApiOperation(value = "批量保存页面", tags = {"页面" },  notes = "批量保存页面")
	@RequestMapping(method = RequestMethod.POST, value = "/dstviews/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<DstViewDTO> dstviewdtos) {
        dstviewService.saveBatch(dstviewMapping.toDomain(dstviewdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-searchDefault-all')")
	@ApiOperation(value = "获取数据集", tags = {"页面" } ,notes = "获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/dstviews/fetchdefault")
	public ResponseEntity<List<DstViewDTO>> fetchDefault(DstViewSearchContext context) {
        Page<DstView> domains = dstviewService.searchDefault(context) ;
        List<DstViewDTO> list = dstviewMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-searchDefault-all')")
	@ApiOperation(value = "查询数据集", tags = {"页面" } ,notes = "查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/dstviews/searchdefault")
	public ResponseEntity<Page<DstViewDTO>> searchDefault(@RequestBody DstViewSearchContext context) {
        Page<DstView> domains = dstviewService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(dstviewMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-Create-all')")
    @ApiOperation(value = "根据应用建立页面", tags = {"页面" },  notes = "根据应用建立页面")
	@RequestMapping(method = RequestMethod.POST, value = "/dstapps/{dstapp_id}/dstviews")
    public ResponseEntity<DstViewDTO> createByDstApp(@PathVariable("dstapp_id") String dstapp_id, @RequestBody DstViewDTO dstviewdto) {
        DstView domain = dstviewMapping.toDomain(dstviewdto);
        domain.setAppId(dstapp_id);
		dstviewService.create(domain);
        DstViewDTO dto = dstviewMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-Create-all')")
    @ApiOperation(value = "根据应用批量建立页面", tags = {"页面" },  notes = "根据应用批量建立页面")
	@RequestMapping(method = RequestMethod.POST, value = "/dstapps/{dstapp_id}/dstviews/batch")
    public ResponseEntity<Boolean> createBatchByDstApp(@PathVariable("dstapp_id") String dstapp_id, @RequestBody List<DstViewDTO> dstviewdtos) {
        List<DstView> domainlist=dstviewMapping.toDomain(dstviewdtos);
        for(DstView domain:domainlist){
            domain.setAppId(dstapp_id);
        }
        dstviewService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "dstview" , versionfield = "updatedate")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-Update-all')")
    @ApiOperation(value = "根据应用更新页面", tags = {"页面" },  notes = "根据应用更新页面")
	@RequestMapping(method = RequestMethod.PUT, value = "/dstapps/{dstapp_id}/dstviews/{dstview_id}")
    public ResponseEntity<DstViewDTO> updateByDstApp(@PathVariable("dstapp_id") String dstapp_id, @PathVariable("dstview_id") String dstview_id, @RequestBody DstViewDTO dstviewdto) {
        DstView domain = dstviewMapping.toDomain(dstviewdto);
        domain.setAppId(dstapp_id);
        domain.setId(dstview_id);
		dstviewService.update(domain);
        DstViewDTO dto = dstviewMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-Update-all')")
    @ApiOperation(value = "根据应用批量更新页面", tags = {"页面" },  notes = "根据应用批量更新页面")
	@RequestMapping(method = RequestMethod.PUT, value = "/dstapps/{dstapp_id}/dstviews/batch")
    public ResponseEntity<Boolean> updateBatchByDstApp(@PathVariable("dstapp_id") String dstapp_id, @RequestBody List<DstViewDTO> dstviewdtos) {
        List<DstView> domainlist=dstviewMapping.toDomain(dstviewdtos);
        for(DstView domain:domainlist){
            domain.setAppId(dstapp_id);
        }
        dstviewService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-Remove-all')")
    @ApiOperation(value = "根据应用删除页面", tags = {"页面" },  notes = "根据应用删除页面")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dstapps/{dstapp_id}/dstviews/{dstview_id}")
    public ResponseEntity<Boolean> removeByDstApp(@PathVariable("dstapp_id") String dstapp_id, @PathVariable("dstview_id") String dstview_id) {
		return ResponseEntity.status(HttpStatus.OK).body(dstviewService.remove(dstview_id));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-Remove-all')")
    @ApiOperation(value = "根据应用批量删除页面", tags = {"页面" },  notes = "根据应用批量删除页面")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dstapps/{dstapp_id}/dstviews/batch")
    public ResponseEntity<Boolean> removeBatchByDstApp(@RequestBody List<String> ids) {
        dstviewService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-Get-all')")
    @ApiOperation(value = "根据应用获取页面", tags = {"页面" },  notes = "根据应用获取页面")
	@RequestMapping(method = RequestMethod.GET, value = "/dstapps/{dstapp_id}/dstviews/{dstview_id}")
    public ResponseEntity<DstViewDTO> getByDstApp(@PathVariable("dstapp_id") String dstapp_id, @PathVariable("dstview_id") String dstview_id) {
        DstView domain = dstviewService.get(dstview_id);
        DstViewDTO dto = dstviewMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据应用获取页面草稿", tags = {"页面" },  notes = "根据应用获取页面草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/dstapps/{dstapp_id}/dstviews/getdraft")
    public ResponseEntity<DstViewDTO> getDraftByDstApp(@PathVariable("dstapp_id") String dstapp_id) {
        DstView domain = new DstView();
        domain.setAppId(dstapp_id);
        return ResponseEntity.status(HttpStatus.OK).body(dstviewMapping.toDto(dstviewService.getDraft(domain)));
    }

    @ApiOperation(value = "根据应用检查页面", tags = {"页面" },  notes = "根据应用检查页面")
	@RequestMapping(method = RequestMethod.POST, value = "/dstapps/{dstapp_id}/dstviews/checkkey")
    public ResponseEntity<Boolean> checkKeyByDstApp(@PathVariable("dstapp_id") String dstapp_id, @RequestBody DstViewDTO dstviewdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(dstviewService.checkKey(dstviewMapping.toDomain(dstviewdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-Save-all')")
    @ApiOperation(value = "根据应用保存页面", tags = {"页面" },  notes = "根据应用保存页面")
	@RequestMapping(method = RequestMethod.POST, value = "/dstapps/{dstapp_id}/dstviews/save")
    public ResponseEntity<Boolean> saveByDstApp(@PathVariable("dstapp_id") String dstapp_id, @RequestBody DstViewDTO dstviewdto) {
        DstView domain = dstviewMapping.toDomain(dstviewdto);
        domain.setAppId(dstapp_id);
        return ResponseEntity.status(HttpStatus.OK).body(dstviewService.save(domain));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-Save-all')")
    @ApiOperation(value = "根据应用批量保存页面", tags = {"页面" },  notes = "根据应用批量保存页面")
	@RequestMapping(method = RequestMethod.POST, value = "/dstapps/{dstapp_id}/dstviews/savebatch")
    public ResponseEntity<Boolean> saveBatchByDstApp(@PathVariable("dstapp_id") String dstapp_id, @RequestBody List<DstViewDTO> dstviewdtos) {
        List<DstView> domainlist=dstviewMapping.toDomain(dstviewdtos);
        for(DstView domain:domainlist){
             domain.setAppId(dstapp_id);
        }
        dstviewService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-searchDefault-all')")
	@ApiOperation(value = "根据应用获取数据集", tags = {"页面" } ,notes = "根据应用获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/dstapps/{dstapp_id}/dstviews/fetchdefault")
	public ResponseEntity<List<DstViewDTO>> fetchDstViewDefaultByDstApp(@PathVariable("dstapp_id") String dstapp_id,DstViewSearchContext context) {
        context.setN_appid_eq(dstapp_id);
        Page<DstView> domains = dstviewService.searchDefault(context) ;
        List<DstViewDTO> list = dstviewMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-searchDefault-all')")
	@ApiOperation(value = "根据应用查询数据集", tags = {"页面" } ,notes = "根据应用查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/dstapps/{dstapp_id}/dstviews/searchdefault")
	public ResponseEntity<Page<DstViewDTO>> searchDstViewDefaultByDstApp(@PathVariable("dstapp_id") String dstapp_id, @RequestBody DstViewSearchContext context) {
        context.setN_appid_eq(dstapp_id);
        Page<DstView> domains = dstviewService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(dstviewMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-Create-all')")
    @ApiOperation(value = "根据系统应用建立页面", tags = {"页面" },  notes = "根据系统应用建立页面")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/dstapps/{dstapp_id}/dstviews")
    public ResponseEntity<DstViewDTO> createByDstSystemDstApp(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstapp_id") String dstapp_id, @RequestBody DstViewDTO dstviewdto) {
        DstView domain = dstviewMapping.toDomain(dstviewdto);
        domain.setAppId(dstapp_id);
		dstviewService.create(domain);
        DstViewDTO dto = dstviewMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-Create-all')")
    @ApiOperation(value = "根据系统应用批量建立页面", tags = {"页面" },  notes = "根据系统应用批量建立页面")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/dstapps/{dstapp_id}/dstviews/batch")
    public ResponseEntity<Boolean> createBatchByDstSystemDstApp(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstapp_id") String dstapp_id, @RequestBody List<DstViewDTO> dstviewdtos) {
        List<DstView> domainlist=dstviewMapping.toDomain(dstviewdtos);
        for(DstView domain:domainlist){
            domain.setAppId(dstapp_id);
        }
        dstviewService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "dstview" , versionfield = "updatedate")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-Update-all')")
    @ApiOperation(value = "根据系统应用更新页面", tags = {"页面" },  notes = "根据系统应用更新页面")
	@RequestMapping(method = RequestMethod.PUT, value = "/dstsystems/{dstsystem_id}/dstapps/{dstapp_id}/dstviews/{dstview_id}")
    public ResponseEntity<DstViewDTO> updateByDstSystemDstApp(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstapp_id") String dstapp_id, @PathVariable("dstview_id") String dstview_id, @RequestBody DstViewDTO dstviewdto) {
        DstView domain = dstviewMapping.toDomain(dstviewdto);
        domain.setAppId(dstapp_id);
        domain.setId(dstview_id);
		dstviewService.update(domain);
        DstViewDTO dto = dstviewMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-Update-all')")
    @ApiOperation(value = "根据系统应用批量更新页面", tags = {"页面" },  notes = "根据系统应用批量更新页面")
	@RequestMapping(method = RequestMethod.PUT, value = "/dstsystems/{dstsystem_id}/dstapps/{dstapp_id}/dstviews/batch")
    public ResponseEntity<Boolean> updateBatchByDstSystemDstApp(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstapp_id") String dstapp_id, @RequestBody List<DstViewDTO> dstviewdtos) {
        List<DstView> domainlist=dstviewMapping.toDomain(dstviewdtos);
        for(DstView domain:domainlist){
            domain.setAppId(dstapp_id);
        }
        dstviewService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-Remove-all')")
    @ApiOperation(value = "根据系统应用删除页面", tags = {"页面" },  notes = "根据系统应用删除页面")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dstsystems/{dstsystem_id}/dstapps/{dstapp_id}/dstviews/{dstview_id}")
    public ResponseEntity<Boolean> removeByDstSystemDstApp(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstapp_id") String dstapp_id, @PathVariable("dstview_id") String dstview_id) {
		return ResponseEntity.status(HttpStatus.OK).body(dstviewService.remove(dstview_id));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-Remove-all')")
    @ApiOperation(value = "根据系统应用批量删除页面", tags = {"页面" },  notes = "根据系统应用批量删除页面")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dstsystems/{dstsystem_id}/dstapps/{dstapp_id}/dstviews/batch")
    public ResponseEntity<Boolean> removeBatchByDstSystemDstApp(@RequestBody List<String> ids) {
        dstviewService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-Get-all')")
    @ApiOperation(value = "根据系统应用获取页面", tags = {"页面" },  notes = "根据系统应用获取页面")
	@RequestMapping(method = RequestMethod.GET, value = "/dstsystems/{dstsystem_id}/dstapps/{dstapp_id}/dstviews/{dstview_id}")
    public ResponseEntity<DstViewDTO> getByDstSystemDstApp(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstapp_id") String dstapp_id, @PathVariable("dstview_id") String dstview_id) {
        DstView domain = dstviewService.get(dstview_id);
        DstViewDTO dto = dstviewMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据系统应用获取页面草稿", tags = {"页面" },  notes = "根据系统应用获取页面草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/dstsystems/{dstsystem_id}/dstapps/{dstapp_id}/dstviews/getdraft")
    public ResponseEntity<DstViewDTO> getDraftByDstSystemDstApp(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstapp_id") String dstapp_id) {
        DstView domain = new DstView();
        domain.setAppId(dstapp_id);
        return ResponseEntity.status(HttpStatus.OK).body(dstviewMapping.toDto(dstviewService.getDraft(domain)));
    }

    @ApiOperation(value = "根据系统应用检查页面", tags = {"页面" },  notes = "根据系统应用检查页面")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/dstapps/{dstapp_id}/dstviews/checkkey")
    public ResponseEntity<Boolean> checkKeyByDstSystemDstApp(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstapp_id") String dstapp_id, @RequestBody DstViewDTO dstviewdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(dstviewService.checkKey(dstviewMapping.toDomain(dstviewdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-Save-all')")
    @ApiOperation(value = "根据系统应用保存页面", tags = {"页面" },  notes = "根据系统应用保存页面")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/dstapps/{dstapp_id}/dstviews/save")
    public ResponseEntity<Boolean> saveByDstSystemDstApp(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstapp_id") String dstapp_id, @RequestBody DstViewDTO dstviewdto) {
        DstView domain = dstviewMapping.toDomain(dstviewdto);
        domain.setAppId(dstapp_id);
        return ResponseEntity.status(HttpStatus.OK).body(dstviewService.save(domain));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-Save-all')")
    @ApiOperation(value = "根据系统应用批量保存页面", tags = {"页面" },  notes = "根据系统应用批量保存页面")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/dstapps/{dstapp_id}/dstviews/savebatch")
    public ResponseEntity<Boolean> saveBatchByDstSystemDstApp(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstapp_id") String dstapp_id, @RequestBody List<DstViewDTO> dstviewdtos) {
        List<DstView> domainlist=dstviewMapping.toDomain(dstviewdtos);
        for(DstView domain:domainlist){
             domain.setAppId(dstapp_id);
        }
        dstviewService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-searchDefault-all')")
	@ApiOperation(value = "根据系统应用获取数据集", tags = {"页面" } ,notes = "根据系统应用获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/dstsystems/{dstsystem_id}/dstapps/{dstapp_id}/dstviews/fetchdefault")
	public ResponseEntity<List<DstViewDTO>> fetchDstViewDefaultByDstSystemDstApp(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstapp_id") String dstapp_id,DstViewSearchContext context) {
        context.setN_appid_eq(dstapp_id);
        Page<DstView> domains = dstviewService.searchDefault(context) ;
        List<DstViewDTO> list = dstviewMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DstView-searchDefault-all')")
	@ApiOperation(value = "根据系统应用查询数据集", tags = {"页面" } ,notes = "根据系统应用查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/dstsystems/{dstsystem_id}/dstapps/{dstapp_id}/dstviews/searchdefault")
	public ResponseEntity<Page<DstViewDTO>> searchDstViewDefaultByDstSystemDstApp(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstapp_id") String dstapp_id, @RequestBody DstViewSearchContext context) {
        context.setN_appid_eq(dstapp_id);
        Page<DstView> domains = dstviewService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(dstviewMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}

