package cn.ibizlab.api.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[DstConfigDTO]
 */
@Data
public class DstConfigDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [CFGID]
     *
     */
    @JSONField(name = "cfg_id")
    @JsonProperty("cfg_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String cfgId;

    /**
     * 属性 [SYSTEMID]
     *
     */
    @JSONField(name = "system_id")
    @JsonProperty("system_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String systemId;

    /**
     * 属性 [CFGTYPE]
     *
     */
    @JSONField(name = "cfg_type")
    @JsonProperty("cfg_type")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String cfgType;

    /**
     * 属性 [TARGETTYPE]
     *
     */
    @JSONField(name = "target_type")
    @JsonProperty("target_type")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String targetType;

    /**
     * 属性 [USERID]
     *
     */
    @JSONField(name = "user_id")
    @JsonProperty("user_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String userId;

    /**
     * 属性 [CFG]
     *
     */
    @JSONField(name = "cfg")
    @JsonProperty("cfg")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    private String cfg;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "update_date" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("update_date")
    private Timestamp updateDate;


    /**
     * 设置 [SYSTEMID]
     */
    public void setSystemId(String  systemId){
        this.systemId = systemId ;
        this.modify("systemid",systemId);
    }

    /**
     * 设置 [CFGTYPE]
     */
    public void setCfgType(String  cfgType){
        this.cfgType = cfgType ;
        this.modify("cfgtype",cfgType);
    }

    /**
     * 设置 [TARGETTYPE]
     */
    public void setTargetType(String  targetType){
        this.targetType = targetType ;
        this.modify("targettype",targetType);
    }

    /**
     * 设置 [CFG]
     */
    public void setCfg(String  cfg){
        this.cfg = cfg ;
        this.modify("cfg",cfg);
    }


}


