package cn.ibizlab.api.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[MetaEntityDTO]
 */
@Data
public class MetaEntityDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [ENTITYID]
     *
     */
    @JSONField(name = "entity_id")
    @JsonProperty("entity_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String entityId;

    /**
     * 属性 [ENTITYNAME]
     *
     */
    @JSONField(name = "entity_name")
    @JsonProperty("entity_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String entityName;

    /**
     * 属性 [LOGICNAME]
     *
     */
    @JSONField(name = "logic_name")
    @JsonProperty("logic_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String logicName;

    /**
     * 属性 [CODENAME]
     *
     */
    @JSONField(name = "code_name")
    @JsonProperty("code_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String codeName;

    /**
     * 属性 [TABLENAME]
     *
     */
    @JSONField(name = "table_name")
    @JsonProperty("table_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String tableName;

    /**
     * 属性 [SYSTEMID]
     *
     */
    @JSONField(name = "system_id")
    @JsonProperty("system_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String systemId;

    /**
     * 属性 [SYSTEMNAME]
     *
     */
    @JSONField(name = "system_name")
    @JsonProperty("system_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String systemName;

    /**
     * 属性 [DSID]
     *
     */
    @JSONField(name = "ds_id")
    @JsonProperty("ds_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String dsId;

    /**
     * 属性 [DSNAME]
     *
     */
    @JSONField(name = "ds_name")
    @JsonProperty("ds_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String dsName;

    /**
     * 属性 [MODULEID]
     *
     */
    @JSONField(name = "module_id")
    @JsonProperty("module_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String moduleId;

    /**
     * 属性 [MODULENAME]
     *
     */
    @JSONField(name = "module_name")
    @JsonProperty("module_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String moduleName;

    /**
     * 属性 [EXTPARAMS]
     *
     */
    @JSONField(name = "ext_params")
    @JsonProperty("ext_params")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    private String extParams;

    /**
     * 属性 [SHOWORDER]
     *
     */
    @JSONField(name = "show_order")
    @JsonProperty("show_order")
    private Integer showOrder;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;


    /**
     * 设置 [ENTITYNAME]
     */
    public void setEntityName(String  entityName){
        this.entityName = entityName ;
        this.modify("entityname",entityName);
    }

    /**
     * 设置 [LOGICNAME]
     */
    public void setLogicName(String  logicName){
        this.logicName = logicName ;
        this.modify("logicname",logicName);
    }

    /**
     * 设置 [CODENAME]
     */
    public void setCodeName(String  codeName){
        this.codeName = codeName ;
        this.modify("codename",codeName);
    }

    /**
     * 设置 [TABLENAME]
     */
    public void setTableName(String  tableName){
        this.tableName = tableName ;
        this.modify("tablename",tableName);
    }

    /**
     * 设置 [SYSTEMID]
     */
    public void setSystemId(String  systemId){
        this.systemId = systemId ;
        this.modify("systemid",systemId);
    }

    /**
     * 设置 [DSID]
     */
    public void setDsId(String  dsId){
        this.dsId = dsId ;
        this.modify("dsid",dsId);
    }

    /**
     * 设置 [MODULEID]
     */
    public void setModuleId(String  moduleId){
        this.moduleId = moduleId ;
        this.modify("moduleid",moduleId);
    }

    /**
     * 设置 [EXTPARAMS]
     */
    public void setExtParams(String  extParams){
        this.extParams = extParams ;
        this.modify("extparams",extParams);
    }

    /**
     * 设置 [SHOWORDER]
     */
    public void setShowOrder(Integer  showOrder){
        this.showOrder = showOrder ;
        this.modify("showorder",showOrder);
    }


}


