import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 数据集服务对象基类
 *
 * @export
 * @class MetaDataSetServiceBase
 * @extends {EntityServie}
 */
export default class MetaDataSetServiceBase extends EntityService {

    /**
     * Creates an instance of  MetaDataSetServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  MetaDataSetServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof MetaDataSetServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='metadataset';
        this.APPDEKEY = 'dataset_id';
        this.APPDENAME = 'metadatasets';
        this.APPDETEXT = 'dataset_name';
        this.APPNAME = 'web';
        this.SYSTEMNAME = 'ibzlite';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaDataSetServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && context.metadataset){
            let res:any = Http.getInstance().get(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metadatasets/${context.metadataset}/select`,isloading);
            
            return res;
        }
        if(context.metaentity && context.metadataset){
            let res:any = Http.getInstance().get(`/metaentities/${context.metaentity}/metadatasets/${context.metadataset}/select`,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().get(`/metadatasets/${context.metadataset}/select`,isloading);
            
            return res;
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaDataSetServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metadatasets`,data,isloading);
            
            return res;
        }
        if(context.metaentity && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/metaentities/${context.metaentity}/metadatasets`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/metadatasets`,data,isloading);
        
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaDataSetServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && context.metadataset){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metadatasets/${context.metadataset}`,data,isloading);
            
            return res;
        }
        if(context.metaentity && context.metadataset){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/metaentities/${context.metaentity}/metadatasets/${context.metadataset}`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/metadatasets/${context.metadataset}`,data,isloading);
            
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaDataSetServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && context.metadataset){
            let res:any = Http.getInstance().delete(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metadatasets/${context.metadataset}`,isloading);
            return res;
        }
        if(context.metaentity && context.metadataset){
            let res:any = Http.getInstance().delete(`/metaentities/${context.metaentity}/metadatasets/${context.metadataset}`,isloading);
            return res;
        }
            let res:any = Http.getInstance().delete(`/metadatasets/${context.metadataset}`,isloading);
            return res;
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaDataSetServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && context.metadataset){
            let res:any = await Http.getInstance().get(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metadatasets/${context.metadataset}`,isloading);
            
            return res;
        }
        if(context.metaentity && context.metadataset){
            let res:any = await Http.getInstance().get(`/metaentities/${context.metaentity}/metadatasets/${context.metadataset}`,isloading);
            
            return res;
        }
            let res:any = await Http.getInstance().get(`/metadatasets/${context.metadataset}`,isloading);
            
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaDataSetServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && true){
            let res:any = await Http.getInstance().get(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metadatasets/getdraft`,isloading);
            res.data.metadataset = data.metadataset;
            
            return res;
        }
        if(context.metaentity && true){
            let res:any = await Http.getInstance().get(`/metaentities/${context.metaentity}/metadatasets/getdraft`,isloading);
            res.data.metadataset = data.metadataset;
            
            return res;
        }
        let res:any = await  Http.getInstance().get(`/metadatasets/getdraft`,isloading);
        res.data.metadataset = data.metadataset;
        
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaDataSetServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && context.metadataset){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metadatasets/${context.metadataset}/checkkey`,data,isloading);
            
            return res;
        }
        if(context.metaentity && context.metadataset){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/metaentities/${context.metaentity}/metadatasets/${context.metadataset}/checkkey`,data,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().post(`/metadatasets/${context.metadataset}/checkkey`,data,isloading);
            return res;
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaDataSetServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && context.metadataset){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metadatasets/${context.metadataset}/save`,data,isloading);
            
            return res;
        }
        if(context.metaentity && context.metadataset){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/metaentities/${context.metaentity}/metadatasets/${context.metadataset}/save`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/metadatasets/${context.metadataset}/save`,data,isloading);
            
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaDataSetServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            let res:any = Http.getInstance().get(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metadatasets/fetchdefault`,tempData,isloading);
            return res;
        }
        if(context.metaentity && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            let res:any = Http.getInstance().get(`/metaentities/${context.metaentity}/metadatasets/fetchdefault`,tempData,isloading);
            return res;
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/metadatasets/fetchdefault`,tempData,isloading);
        return res;
    }
}