import Vue from 'vue';
import Router from 'vue-router';
import { AuthGuard } from '@/utils';
import qs from 'qs';
import { globalRoutes, indexRoutes} from '@/router'

Vue.use(Router);

const router = new Router({
    routes: [
        {
            path: '/liteindex/:liteindex?',
            beforeEnter: (to: any, from: any, next: any) => {
                const routerParamsName = 'liteindex';
                const params: any = {};
                if (to.params && to.params[routerParamsName]) {
                    Object.assign(params, qs.parse(to.params[routerParamsName], { delimiter: ';' }));
                }
                const url: string = '/appdata';
                const auth: Promise<any> = AuthGuard.getInstance().authGuard(url, params, router);
                auth.then(() => {
                    next();
                }).catch(() => {
                    next();
                });
            },
            meta: {  
                caption: 'app.views.liteindex.caption',
                info:'',
                viewType: 'APPINDEX',
                parameters: [
                    { pathName: 'liteindex', parameterName: 'liteindex' },
                ],
                requireAuth: true,
            },
            component: () => import('@pages/lite/lite-index/lite-index.vue'),
            children: [
                {
                    path: 'dstsystems/:dstsystem?/dstmicroservices/:dstmicroservice?/editview/:editview?',
                    meta: {
                        caption: 'entities.dstmicroservice.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'dstmicroservices', parameterName: 'dstmicroservice' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-microservice-edit-view/dst-microservice-edit-view.vue'),
                },
                {
                    path: 'dstmicroservices/:dstmicroservice?/editview/:editview?',
                    meta: {
                        caption: 'entities.dstmicroservice.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstmicroservices', parameterName: 'dstmicroservice' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-microservice-edit-view/dst-microservice-edit-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.dstsystem.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-system-grid-view/dst-system-grid-view.vue'),
                },
                {
                    path: 'metamodels/:metamodel?/editview/:editview?',
                    meta: {
                        caption: 'entities.metamodel.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metamodels', parameterName: 'metamodel' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-model-edit-view/meta-model-edit-view.vue'),
                },
                {
                    path: 'metadynamicmodels/:metadynamicmodel?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.metadynamicmodel.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metadynamicmodels', parameterName: 'metadynamicmodel' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-dynamic-model-grid-view/meta-dynamic-model-grid-view.vue'),
                },
                {
                    path: 'dstdatasources/:dstdatasource?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.dstdatasource.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstdatasources', parameterName: 'dstdatasource' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-data-source-grid-view/dst-data-source-grid-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/dstmicroservices/:dstmicroservice?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.dstmicroservice.views.pickupgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'dstmicroservices', parameterName: 'dstmicroservice' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-microservice-pickup-grid-view/dst-microservice-pickup-grid-view.vue'),
                },
                {
                    path: 'dstmicroservices/:dstmicroservice?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.dstmicroservice.views.pickupgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstmicroservices', parameterName: 'dstmicroservice' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-microservice-pickup-grid-view/dst-microservice-pickup-grid-view.vue'),
                },
                {
                    path: 'dstdatasources/:dstdatasource?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.dstdatasource.views.pickupgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstdatasources', parameterName: 'dstdatasource' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-data-source-pickup-grid-view/dst-data-source-pickup-grid-view.vue'),
                },
                {
                    path: 'dstconfigs/:dstconfig?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.dstconfig.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstconfigs', parameterName: 'dstconfig' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-config-grid-view/dst-config-grid-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/metaentities/:metaentity?/metarelationships/:metarelationship?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.metarelationship.views.pickupview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'metaentities', parameterName: 'metaentity' },
                            { pathName: 'metarelationships', parameterName: 'metarelationship' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-relationship-pickup-view/meta-relationship-pickup-view.vue'),
                },
                {
                    path: 'metaentities/:metaentity?/metarelationships/:metarelationship?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.metarelationship.views.pickupview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metaentities', parameterName: 'metaentity' },
                            { pathName: 'metarelationships', parameterName: 'metarelationship' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-relationship-pickup-view/meta-relationship-pickup-view.vue'),
                },
                {
                    path: 'metarelationships/:metarelationship?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.metarelationship.views.pickupview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metarelationships', parameterName: 'metarelationship' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-relationship-pickup-view/meta-relationship-pickup-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/dstmicroservices/:dstmicroservice?/dstapis/:dstapi?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.dstapi.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'dstmicroservices', parameterName: 'dstmicroservice' },
                            { pathName: 'dstapis', parameterName: 'dstapi' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-apigrid-view/dst-apigrid-view.vue'),
                },
                {
                    path: 'dstmicroservices/:dstmicroservice?/dstapis/:dstapi?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.dstapi.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstmicroservices', parameterName: 'dstmicroservice' },
                            { pathName: 'dstapis', parameterName: 'dstapi' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-apigrid-view/dst-apigrid-view.vue'),
                },
                {
                    path: 'dstapis/:dstapi?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.dstapi.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstapis', parameterName: 'dstapi' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-apigrid-view/dst-apigrid-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/metaentities/:metaentity?/metafields/:metafield?/editview/:editview?',
                    meta: {
                        caption: 'entities.metafield.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'metaentities', parameterName: 'metaentity' },
                            { pathName: 'metafields', parameterName: 'metafield' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-field-edit-view/meta-field-edit-view.vue'),
                },
                {
                    path: 'metaentities/:metaentity?/metafields/:metafield?/editview/:editview?',
                    meta: {
                        caption: 'entities.metafield.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metaentities', parameterName: 'metaentity' },
                            { pathName: 'metafields', parameterName: 'metafield' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-field-edit-view/meta-field-edit-view.vue'),
                },
                {
                    path: 'metafields/:metafield?/editview/:editview?',
                    meta: {
                        caption: 'entities.metafield.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metafields', parameterName: 'metafield' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-field-edit-view/meta-field-edit-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/metaentities/:metaentity?/metadatasets/:metadataset?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.metadataset.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'metaentities', parameterName: 'metaentity' },
                            { pathName: 'metadatasets', parameterName: 'metadataset' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-data-set-grid-view/meta-data-set-grid-view.vue'),
                },
                {
                    path: 'metaentities/:metaentity?/metadatasets/:metadataset?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.metadataset.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metaentities', parameterName: 'metaentity' },
                            { pathName: 'metadatasets', parameterName: 'metadataset' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-data-set-grid-view/meta-data-set-grid-view.vue'),
                },
                {
                    path: 'metadatasets/:metadataset?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.metadataset.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metadatasets', parameterName: 'metadataset' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-data-set-grid-view/meta-data-set-grid-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/dstapps/:dstapp?/dstviews/:dstview?/editview/:editview?',
                    meta: {
                        caption: 'entities.dstview.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'dstapps', parameterName: 'dstapp' },
                            { pathName: 'dstviews', parameterName: 'dstview' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-view-edit-view/dst-view-edit-view.vue'),
                },
                {
                    path: 'dstapps/:dstapp?/dstviews/:dstview?/editview/:editview?',
                    meta: {
                        caption: 'entities.dstview.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstapps', parameterName: 'dstapp' },
                            { pathName: 'dstviews', parameterName: 'dstview' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-view-edit-view/dst-view-edit-view.vue'),
                },
                {
                    path: 'dstviews/:dstview?/editview/:editview?',
                    meta: {
                        caption: 'entities.dstview.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstviews', parameterName: 'dstview' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-view-edit-view/dst-view-edit-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/metaentities/:metaentity?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.metaentity.views.pickupview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'metaentities', parameterName: 'metaentity' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-entity-pickup-view/meta-entity-pickup-view.vue'),
                },
                {
                    path: 'metaentities/:metaentity?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.metaentity.views.pickupview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metaentities', parameterName: 'metaentity' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-entity-pickup-view/meta-entity-pickup-view.vue'),
                },
                {
                    path: 'dstconfigs/:dstconfig?/editview/:editview?',
                    meta: {
                        caption: 'entities.dstconfig.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstconfigs', parameterName: 'dstconfig' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-config-edit-view/dst-config-edit-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/metaentities/:metaentity?/metadatasets/:metadataset?/editview/:editview?',
                    meta: {
                        caption: 'entities.metadataset.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'metaentities', parameterName: 'metaentity' },
                            { pathName: 'metadatasets', parameterName: 'metadataset' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-data-set-edit-view/meta-data-set-edit-view.vue'),
                },
                {
                    path: 'metaentities/:metaentity?/metadatasets/:metadataset?/editview/:editview?',
                    meta: {
                        caption: 'entities.metadataset.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metaentities', parameterName: 'metaentity' },
                            { pathName: 'metadatasets', parameterName: 'metadataset' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-data-set-edit-view/meta-data-set-edit-view.vue'),
                },
                {
                    path: 'metadatasets/:metadataset?/editview/:editview?',
                    meta: {
                        caption: 'entities.metadataset.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metadatasets', parameterName: 'metadataset' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-data-set-edit-view/meta-data-set-edit-view.vue'),
                },
                {
                    path: 'metamodels/:metamodel?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.metamodel.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metamodels', parameterName: 'metamodel' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-model-grid-view/meta-model-grid-view.vue'),
                },
                {
                    path: 'metamodules/:metamodule?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.metamodule.views.pickupview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metamodules', parameterName: 'metamodule' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-module-pickup-view/meta-module-pickup-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/dstapps/:dstapp?/dstrouters/:dstrouter?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.dstrouter.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'dstapps', parameterName: 'dstapp' },
                            { pathName: 'dstrouters', parameterName: 'dstrouter' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-router-grid-view/dst-router-grid-view.vue'),
                },
                {
                    path: 'dstapps/:dstapp?/dstrouters/:dstrouter?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.dstrouter.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstapps', parameterName: 'dstapp' },
                            { pathName: 'dstrouters', parameterName: 'dstrouter' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-router-grid-view/dst-router-grid-view.vue'),
                },
                {
                    path: 'dstrouters/:dstrouter?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.dstrouter.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstrouters', parameterName: 'dstrouter' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-router-grid-view/dst-router-grid-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/editview/:editview?',
                    meta: {
                        caption: 'entities.dstsystem.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-system-edit-view/dst-system-edit-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/dstmicroservices/:dstmicroservice?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.dstmicroservice.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'dstmicroservices', parameterName: 'dstmicroservice' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-microservice-grid-view/dst-microservice-grid-view.vue'),
                },
                {
                    path: 'dstmicroservices/:dstmicroservice?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.dstmicroservice.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstmicroservices', parameterName: 'dstmicroservice' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-microservice-grid-view/dst-microservice-grid-view.vue'),
                },
                {
                    path: 'metamodules/:metamodule?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.metamodule.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metamodules', parameterName: 'metamodule' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-module-grid-view/meta-module-grid-view.vue'),
                },
                {
                    path: 'bladevisuals/:bladevisual?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.bladevisual.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'bladevisuals', parameterName: 'bladevisual' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/avuedata/blade-visual-grid-view/blade-visual-grid-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/metaentities/:metaentity?/metafields/:metafield?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.metafield.views.pickupview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'metaentities', parameterName: 'metaentity' },
                            { pathName: 'metafields', parameterName: 'metafield' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-field-pickup-view/meta-field-pickup-view.vue'),
                },
                {
                    path: 'metaentities/:metaentity?/metafields/:metafield?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.metafield.views.pickupview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metaentities', parameterName: 'metaentity' },
                            { pathName: 'metafields', parameterName: 'metafield' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-field-pickup-view/meta-field-pickup-view.vue'),
                },
                {
                    path: 'metafields/:metafield?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.metafield.views.pickupview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metafields', parameterName: 'metafield' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-field-pickup-view/meta-field-pickup-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/metaentities/:metaentity?/metarelationships/:metarelationship?/editview/:editview?',
                    meta: {
                        caption: 'entities.metarelationship.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'metaentities', parameterName: 'metaentity' },
                            { pathName: 'metarelationships', parameterName: 'metarelationship' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-relationship-edit-view/meta-relationship-edit-view.vue'),
                },
                {
                    path: 'metaentities/:metaentity?/metarelationships/:metarelationship?/editview/:editview?',
                    meta: {
                        caption: 'entities.metarelationship.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metaentities', parameterName: 'metaentity' },
                            { pathName: 'metarelationships', parameterName: 'metarelationship' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-relationship-edit-view/meta-relationship-edit-view.vue'),
                },
                {
                    path: 'metarelationships/:metarelationship?/editview/:editview?',
                    meta: {
                        caption: 'entities.metarelationship.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metarelationships', parameterName: 'metarelationship' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-relationship-edit-view/meta-relationship-edit-view.vue'),
                },
                {
                    path: 'dstdatasources/:dstdatasource?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.dstdatasource.views.pickupview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstdatasources', parameterName: 'dstdatasource' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-data-source-pickup-view/dst-data-source-pickup-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/metaentities/:metaentity?/metafields/:metafield?/editgridview/:editgridview?',
                    meta: {
                        caption: 'entities.metafield.views.editgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'metaentities', parameterName: 'metaentity' },
                            { pathName: 'metafields', parameterName: 'metafield' },
                            { pathName: 'editgridview', parameterName: 'editgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-field-edit-grid-view/meta-field-edit-grid-view.vue'),
                },
                {
                    path: 'metaentities/:metaentity?/metafields/:metafield?/editgridview/:editgridview?',
                    meta: {
                        caption: 'entities.metafield.views.editgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metaentities', parameterName: 'metaentity' },
                            { pathName: 'metafields', parameterName: 'metafield' },
                            { pathName: 'editgridview', parameterName: 'editgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-field-edit-grid-view/meta-field-edit-grid-view.vue'),
                },
                {
                    path: 'metafields/:metafield?/editgridview/:editgridview?',
                    meta: {
                        caption: 'entities.metafield.views.editgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metafields', parameterName: 'metafield' },
                            { pathName: 'editgridview', parameterName: 'editgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-field-edit-grid-view/meta-field-edit-grid-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/dstapps/:dstapp?/dstcomponents/:dstcomponent?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.dstcomponent.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'dstapps', parameterName: 'dstapp' },
                            { pathName: 'dstcomponents', parameterName: 'dstcomponent' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-component-grid-view/dst-component-grid-view.vue'),
                },
                {
                    path: 'dstapps/:dstapp?/dstcomponents/:dstcomponent?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.dstcomponent.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstapps', parameterName: 'dstapp' },
                            { pathName: 'dstcomponents', parameterName: 'dstcomponent' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-component-grid-view/dst-component-grid-view.vue'),
                },
                {
                    path: 'dstcomponents/:dstcomponent?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.dstcomponent.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstcomponents', parameterName: 'dstcomponent' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-component-grid-view/dst-component-grid-view.vue'),
                },
                {
                    path: 'metamodules/:metamodule?/editview/:editview?',
                    meta: {
                        caption: 'entities.metamodule.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metamodules', parameterName: 'metamodule' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-module-edit-view/meta-module-edit-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/metaentities/:metaentity?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.metaentity.views.pickupgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'metaentities', parameterName: 'metaentity' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-entity-pickup-grid-view/meta-entity-pickup-grid-view.vue'),
                },
                {
                    path: 'metaentities/:metaentity?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.metaentity.views.pickupgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metaentities', parameterName: 'metaentity' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-entity-pickup-grid-view/meta-entity-pickup-grid-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/metaentities/:metaentity?/metarelationships/:metarelationship?/editgridview/:editgridview?',
                    meta: {
                        caption: 'entities.metarelationship.views.editgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'metaentities', parameterName: 'metaentity' },
                            { pathName: 'metarelationships', parameterName: 'metarelationship' },
                            { pathName: 'editgridview', parameterName: 'editgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-relationship-edit-grid-view/meta-relationship-edit-grid-view.vue'),
                },
                {
                    path: 'metaentities/:metaentity?/metarelationships/:metarelationship?/editgridview/:editgridview?',
                    meta: {
                        caption: 'entities.metarelationship.views.editgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metaentities', parameterName: 'metaentity' },
                            { pathName: 'metarelationships', parameterName: 'metarelationship' },
                            { pathName: 'editgridview', parameterName: 'editgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-relationship-edit-grid-view/meta-relationship-edit-grid-view.vue'),
                },
                {
                    path: 'metarelationships/:metarelationship?/editgridview/:editgridview?',
                    meta: {
                        caption: 'entities.metarelationship.views.editgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metarelationships', parameterName: 'metarelationship' },
                            { pathName: 'editgridview', parameterName: 'editgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-relationship-edit-grid-view/meta-relationship-edit-grid-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/metaentities/:metaentity?/editview/:editview?',
                    meta: {
                        caption: 'entities.metaentity.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'metaentities', parameterName: 'metaentity' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-entity-edit-view/meta-entity-edit-view.vue'),
                },
                {
                    path: 'metaentities/:metaentity?/editview/:editview?',
                    meta: {
                        caption: 'entities.metaentity.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metaentities', parameterName: 'metaentity' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-entity-edit-view/meta-entity-edit-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/dstmicroservices/:dstmicroservice?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.dstmicroservice.views.pickupview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'dstmicroservices', parameterName: 'dstmicroservice' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-microservice-pickup-view/dst-microservice-pickup-view.vue'),
                },
                {
                    path: 'dstmicroservices/:dstmicroservice?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.dstmicroservice.views.pickupview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstmicroservices', parameterName: 'dstmicroservice' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-microservice-pickup-view/dst-microservice-pickup-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/metaentities/:metaentity?/metafields/:metafield?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.metafield.views.pickupgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'metaentities', parameterName: 'metaentity' },
                            { pathName: 'metafields', parameterName: 'metafield' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-field-pickup-grid-view/meta-field-pickup-grid-view.vue'),
                },
                {
                    path: 'metaentities/:metaentity?/metafields/:metafield?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.metafield.views.pickupgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metaentities', parameterName: 'metaentity' },
                            { pathName: 'metafields', parameterName: 'metafield' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-field-pickup-grid-view/meta-field-pickup-grid-view.vue'),
                },
                {
                    path: 'metafields/:metafield?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.metafield.views.pickupgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metafields', parameterName: 'metafield' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-field-pickup-grid-view/meta-field-pickup-grid-view.vue'),
                },
                {
                    path: 'metadynamicmodels/:metadynamicmodel?/editview/:editview?',
                    meta: {
                        caption: 'entities.metadynamicmodel.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metadynamicmodels', parameterName: 'metadynamicmodel' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-dynamic-model-edit-view/meta-dynamic-model-edit-view.vue'),
                },
                {
                    path: 'bladevisuals/:bladevisual?/editview/:editview?',
                    meta: {
                        caption: 'entities.bladevisual.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'bladevisuals', parameterName: 'bladevisual' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/avuedata/blade-visual-edit-view/blade-visual-edit-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/dstapps/:dstapp?/dstcomponents/:dstcomponent?/editview/:editview?',
                    meta: {
                        caption: 'entities.dstcomponent.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'dstapps', parameterName: 'dstapp' },
                            { pathName: 'dstcomponents', parameterName: 'dstcomponent' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-component-edit-view/dst-component-edit-view.vue'),
                },
                {
                    path: 'dstapps/:dstapp?/dstcomponents/:dstcomponent?/editview/:editview?',
                    meta: {
                        caption: 'entities.dstcomponent.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstapps', parameterName: 'dstapp' },
                            { pathName: 'dstcomponents', parameterName: 'dstcomponent' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-component-edit-view/dst-component-edit-view.vue'),
                },
                {
                    path: 'dstcomponents/:dstcomponent?/editview/:editview?',
                    meta: {
                        caption: 'entities.dstcomponent.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstcomponents', parameterName: 'dstcomponent' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-component-edit-view/dst-component-edit-view.vue'),
                },
                {
                    path: 'metamodules/:metamodule?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.metamodule.views.pickupgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metamodules', parameterName: 'metamodule' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-module-pickup-grid-view/meta-module-pickup-grid-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/dstapps/:dstapp?/dstrouters/:dstrouter?/editview/:editview?',
                    meta: {
                        caption: 'entities.dstrouter.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'dstapps', parameterName: 'dstapp' },
                            { pathName: 'dstrouters', parameterName: 'dstrouter' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-router-edit-view/dst-router-edit-view.vue'),
                },
                {
                    path: 'dstapps/:dstapp?/dstrouters/:dstrouter?/editview/:editview?',
                    meta: {
                        caption: 'entities.dstrouter.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstapps', parameterName: 'dstapp' },
                            { pathName: 'dstrouters', parameterName: 'dstrouter' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-router-edit-view/dst-router-edit-view.vue'),
                },
                {
                    path: 'dstrouters/:dstrouter?/editview/:editview?',
                    meta: {
                        caption: 'entities.dstrouter.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstrouters', parameterName: 'dstrouter' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-router-edit-view/dst-router-edit-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/dstapps/:dstapp?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.dstapp.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'dstapps', parameterName: 'dstapp' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-app-grid-view/dst-app-grid-view.vue'),
                },
                {
                    path: 'dstapps/:dstapp?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.dstapp.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstapps', parameterName: 'dstapp' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-app-grid-view/dst-app-grid-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/dstapps/:dstapp?/dstviews/:dstview?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.dstview.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'dstapps', parameterName: 'dstapp' },
                            { pathName: 'dstviews', parameterName: 'dstview' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-view-grid-view/dst-view-grid-view.vue'),
                },
                {
                    path: 'dstapps/:dstapp?/dstviews/:dstview?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.dstview.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstapps', parameterName: 'dstapp' },
                            { pathName: 'dstviews', parameterName: 'dstview' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-view-grid-view/dst-view-grid-view.vue'),
                },
                {
                    path: 'dstviews/:dstview?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.dstview.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstviews', parameterName: 'dstview' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-view-grid-view/dst-view-grid-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/metaentities/:metaentity?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.metaentity.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'metaentities', parameterName: 'metaentity' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-entity-grid-view/meta-entity-grid-view.vue'),
                },
                {
                    path: 'metaentities/:metaentity?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.metaentity.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metaentities', parameterName: 'metaentity' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-entity-grid-view/meta-entity-grid-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/dstmicroservices/:dstmicroservice?/dstapis/:dstapi?/editview/:editview?',
                    meta: {
                        caption: 'entities.dstapi.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'dstmicroservices', parameterName: 'dstmicroservice' },
                            { pathName: 'dstapis', parameterName: 'dstapi' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-apiedit-view/dst-apiedit-view.vue'),
                },
                {
                    path: 'dstmicroservices/:dstmicroservice?/dstapis/:dstapi?/editview/:editview?',
                    meta: {
                        caption: 'entities.dstapi.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstmicroservices', parameterName: 'dstmicroservice' },
                            { pathName: 'dstapis', parameterName: 'dstapi' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-apiedit-view/dst-apiedit-view.vue'),
                },
                {
                    path: 'dstapis/:dstapi?/editview/:editview?',
                    meta: {
                        caption: 'entities.dstapi.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstapis', parameterName: 'dstapi' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-apiedit-view/dst-apiedit-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/dstapps/:dstapp?/editview/:editview?',
                    meta: {
                        caption: 'entities.dstapp.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'dstapps', parameterName: 'dstapp' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-app-edit-view/dst-app-edit-view.vue'),
                },
                {
                    path: 'dstapps/:dstapp?/editview/:editview?',
                    meta: {
                        caption: 'entities.dstapp.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstapps', parameterName: 'dstapp' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-app-edit-view/dst-app-edit-view.vue'),
                },
                {
                    path: 'dstsystems/:dstsystem?/metaentities/:metaentity?/metarelationships/:metarelationship?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.metarelationship.views.pickupgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstsystems', parameterName: 'dstsystem' },
                            { pathName: 'metaentities', parameterName: 'metaentity' },
                            { pathName: 'metarelationships', parameterName: 'metarelationship' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-relationship-pickup-grid-view/meta-relationship-pickup-grid-view.vue'),
                },
                {
                    path: 'metaentities/:metaentity?/metarelationships/:metarelationship?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.metarelationship.views.pickupgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metaentities', parameterName: 'metaentity' },
                            { pathName: 'metarelationships', parameterName: 'metarelationship' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-relationship-pickup-grid-view/meta-relationship-pickup-grid-view.vue'),
                },
                {
                    path: 'metarelationships/:metarelationship?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.metarelationship.views.pickupgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'metarelationships', parameterName: 'metarelationship' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/meta-relationship-pickup-grid-view/meta-relationship-pickup-grid-view.vue'),
                },
                {
                    path: 'dstdatasources/:dstdatasource?/editview/:editview?',
                    meta: {
                        caption: 'entities.dstdatasource.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'liteindex', parameterName: 'liteindex' },
                            { pathName: 'dstdatasources', parameterName: 'dstdatasource' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/lite/dst-data-source-edit-view/dst-data-source-edit-view.vue'),
                },
            ...indexRoutes,
            ],
        },
    {
        path: '/metamodels/:metamodel?/editview/:editview?',
        meta: {
            caption: 'entities.metamodel.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'metamodels', parameterName: 'metamodel' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-model-edit-view/meta-model-edit-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/dstapps/:dstapp?/dstcomponents/:dstcomponent?/gridview/:gridview?',
        meta: {
            caption: 'entities.dstcomponent.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'dstapps', parameterName: 'dstapp' },
                { pathName: 'dstcomponents', parameterName: 'dstcomponent' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-component-grid-view/dst-component-grid-view.vue'),
    },
    {
        path: '/dstapps/:dstapp?/dstcomponents/:dstcomponent?/gridview/:gridview?',
        meta: {
            caption: 'entities.dstcomponent.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstapps', parameterName: 'dstapp' },
                { pathName: 'dstcomponents', parameterName: 'dstcomponent' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-component-grid-view/dst-component-grid-view.vue'),
    },
    {
        path: '/dstcomponents/:dstcomponent?/gridview/:gridview?',
        meta: {
            caption: 'entities.dstcomponent.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstcomponents', parameterName: 'dstcomponent' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-component-grid-view/dst-component-grid-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/dstmicroservices/:dstmicroservice?/dstapis/:dstapi?/gridview/:gridview?',
        meta: {
            caption: 'entities.dstapi.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'dstmicroservices', parameterName: 'dstmicroservice' },
                { pathName: 'dstapis', parameterName: 'dstapi' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-apigrid-view/dst-apigrid-view.vue'),
    },
    {
        path: '/dstmicroservices/:dstmicroservice?/dstapis/:dstapi?/gridview/:gridview?',
        meta: {
            caption: 'entities.dstapi.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstmicroservices', parameterName: 'dstmicroservice' },
                { pathName: 'dstapis', parameterName: 'dstapi' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-apigrid-view/dst-apigrid-view.vue'),
    },
    {
        path: '/dstapis/:dstapi?/gridview/:gridview?',
        meta: {
            caption: 'entities.dstapi.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstapis', parameterName: 'dstapi' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-apigrid-view/dst-apigrid-view.vue'),
    },
    {
        path: '/metadynamicmodels/:metadynamicmodel?/editview/:editview?',
        meta: {
            caption: 'entities.metadynamicmodel.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'metadynamicmodels', parameterName: 'metadynamicmodel' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-dynamic-model-edit-view/meta-dynamic-model-edit-view.vue'),
    },
    {
        path: '/metamodels/:metamodel?/gridview/:gridview?',
        meta: {
            caption: 'entities.metamodel.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'metamodels', parameterName: 'metamodel' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-model-grid-view/meta-model-grid-view.vue'),
    },
    {
        path: '/bladevisuals/:bladevisual?/gridview/:gridview?',
        meta: {
            caption: 'entities.bladevisual.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'bladevisuals', parameterName: 'bladevisual' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/avuedata/blade-visual-grid-view/blade-visual-grid-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/dstapps/:dstapp?/gridview/:gridview?',
        meta: {
            caption: 'entities.dstapp.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'dstapps', parameterName: 'dstapp' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-app-grid-view/dst-app-grid-view.vue'),
    },
    {
        path: '/dstapps/:dstapp?/gridview/:gridview?',
        meta: {
            caption: 'entities.dstapp.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstapps', parameterName: 'dstapp' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-app-grid-view/dst-app-grid-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/dstapps/:dstapp?/editview/:editview?',
        meta: {
            caption: 'entities.dstapp.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'dstapps', parameterName: 'dstapp' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-app-edit-view/dst-app-edit-view.vue'),
    },
    {
        path: '/dstapps/:dstapp?/editview/:editview?',
        meta: {
            caption: 'entities.dstapp.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'dstapps', parameterName: 'dstapp' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-app-edit-view/dst-app-edit-view.vue'),
    },
    {
        path: '/dstdatasources/:dstdatasource?/editview/:editview?',
        meta: {
            caption: 'entities.dstdatasource.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'dstdatasources', parameterName: 'dstdatasource' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-data-source-edit-view/dst-data-source-edit-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/metaentities/:metaentity?/pickupview/:pickupview?',
        meta: {
            caption: 'entities.metaentity.views.pickupview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-entity-pickup-view/meta-entity-pickup-view.vue'),
    },
    {
        path: '/metaentities/:metaentity?/pickupview/:pickupview?',
        meta: {
            caption: 'entities.metaentity.views.pickupview.caption',
            info:'',
            parameters: [
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-entity-pickup-view/meta-entity-pickup-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/metaentities/:metaentity?/editview/:editview?',
        meta: {
            caption: 'entities.metaentity.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-entity-edit-view/meta-entity-edit-view.vue'),
    },
    {
        path: '/metaentities/:metaentity?/editview/:editview?',
        meta: {
            caption: 'entities.metaentity.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-entity-edit-view/meta-entity-edit-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/metaentities/:metaentity?/metafields/:metafield?/pickupview/:pickupview?',
        meta: {
            caption: 'entities.metafield.views.pickupview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'metafields', parameterName: 'metafield' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-field-pickup-view/meta-field-pickup-view.vue'),
    },
    {
        path: '/metaentities/:metaentity?/metafields/:metafield?/pickupview/:pickupview?',
        meta: {
            caption: 'entities.metafield.views.pickupview.caption',
            info:'',
            parameters: [
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'metafields', parameterName: 'metafield' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-field-pickup-view/meta-field-pickup-view.vue'),
    },
    {
        path: '/metafields/:metafield?/pickupview/:pickupview?',
        meta: {
            caption: 'entities.metafield.views.pickupview.caption',
            info:'',
            parameters: [
                { pathName: 'metafields', parameterName: 'metafield' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-field-pickup-view/meta-field-pickup-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/dstapps/:dstapp?/dstviews/:dstview?/gridview/:gridview?',
        meta: {
            caption: 'entities.dstview.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'dstapps', parameterName: 'dstapp' },
                { pathName: 'dstviews', parameterName: 'dstview' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-view-grid-view/dst-view-grid-view.vue'),
    },
    {
        path: '/dstapps/:dstapp?/dstviews/:dstview?/gridview/:gridview?',
        meta: {
            caption: 'entities.dstview.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstapps', parameterName: 'dstapp' },
                { pathName: 'dstviews', parameterName: 'dstview' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-view-grid-view/dst-view-grid-view.vue'),
    },
    {
        path: '/dstviews/:dstview?/gridview/:gridview?',
        meta: {
            caption: 'entities.dstview.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstviews', parameterName: 'dstview' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-view-grid-view/dst-view-grid-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/metaentities/:metaentity?/metadatasets/:metadataset?/gridview/:gridview?',
        meta: {
            caption: 'entities.metadataset.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'metadatasets', parameterName: 'metadataset' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-data-set-grid-view/meta-data-set-grid-view.vue'),
    },
    {
        path: '/metaentities/:metaentity?/metadatasets/:metadataset?/gridview/:gridview?',
        meta: {
            caption: 'entities.metadataset.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'metadatasets', parameterName: 'metadataset' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-data-set-grid-view/meta-data-set-grid-view.vue'),
    },
    {
        path: '/metadatasets/:metadataset?/gridview/:gridview?',
        meta: {
            caption: 'entities.metadataset.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'metadatasets', parameterName: 'metadataset' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-data-set-grid-view/meta-data-set-grid-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/dstapps/:dstapp?/dstcomponents/:dstcomponent?/editview/:editview?',
        meta: {
            caption: 'entities.dstcomponent.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'dstapps', parameterName: 'dstapp' },
                { pathName: 'dstcomponents', parameterName: 'dstcomponent' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-component-edit-view/dst-component-edit-view.vue'),
    },
    {
        path: '/dstapps/:dstapp?/dstcomponents/:dstcomponent?/editview/:editview?',
        meta: {
            caption: 'entities.dstcomponent.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'dstapps', parameterName: 'dstapp' },
                { pathName: 'dstcomponents', parameterName: 'dstcomponent' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-component-edit-view/dst-component-edit-view.vue'),
    },
    {
        path: '/dstcomponents/:dstcomponent?/editview/:editview?',
        meta: {
            caption: 'entities.dstcomponent.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'dstcomponents', parameterName: 'dstcomponent' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-component-edit-view/dst-component-edit-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/metaentities/:metaentity?/metarelationships/:metarelationship?/editview/:editview?',
        meta: {
            caption: 'entities.metarelationship.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'metarelationships', parameterName: 'metarelationship' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-relationship-edit-view/meta-relationship-edit-view.vue'),
    },
    {
        path: '/metaentities/:metaentity?/metarelationships/:metarelationship?/editview/:editview?',
        meta: {
            caption: 'entities.metarelationship.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'metarelationships', parameterName: 'metarelationship' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-relationship-edit-view/meta-relationship-edit-view.vue'),
    },
    {
        path: '/metarelationships/:metarelationship?/editview/:editview?',
        meta: {
            caption: 'entities.metarelationship.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'metarelationships', parameterName: 'metarelationship' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-relationship-edit-view/meta-relationship-edit-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/metaentities/:metaentity?/metarelationships/:metarelationship?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'entities.metarelationship.views.pickupgridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'metarelationships', parameterName: 'metarelationship' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-relationship-pickup-grid-view/meta-relationship-pickup-grid-view.vue'),
    },
    {
        path: '/metaentities/:metaentity?/metarelationships/:metarelationship?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'entities.metarelationship.views.pickupgridview.caption',
            info:'',
            parameters: [
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'metarelationships', parameterName: 'metarelationship' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-relationship-pickup-grid-view/meta-relationship-pickup-grid-view.vue'),
    },
    {
        path: '/metarelationships/:metarelationship?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'entities.metarelationship.views.pickupgridview.caption',
            info:'',
            parameters: [
                { pathName: 'metarelationships', parameterName: 'metarelationship' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-relationship-pickup-grid-view/meta-relationship-pickup-grid-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/dstmicroservices/:dstmicroservice?/gridview/:gridview?',
        meta: {
            caption: 'entities.dstmicroservice.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'dstmicroservices', parameterName: 'dstmicroservice' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-microservice-grid-view/dst-microservice-grid-view.vue'),
    },
    {
        path: '/dstmicroservices/:dstmicroservice?/gridview/:gridview?',
        meta: {
            caption: 'entities.dstmicroservice.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstmicroservices', parameterName: 'dstmicroservice' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-microservice-grid-view/dst-microservice-grid-view.vue'),
    },
    {
        path: '/metadynamicmodels/:metadynamicmodel?/gridview/:gridview?',
        meta: {
            caption: 'entities.metadynamicmodel.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'metadynamicmodels', parameterName: 'metadynamicmodel' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-dynamic-model-grid-view/meta-dynamic-model-grid-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/dstmicroservices/:dstmicroservice?/dstapis/:dstapi?/editview/:editview?',
        meta: {
            caption: 'entities.dstapi.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'dstmicroservices', parameterName: 'dstmicroservice' },
                { pathName: 'dstapis', parameterName: 'dstapi' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-apiedit-view/dst-apiedit-view.vue'),
    },
    {
        path: '/dstmicroservices/:dstmicroservice?/dstapis/:dstapi?/editview/:editview?',
        meta: {
            caption: 'entities.dstapi.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'dstmicroservices', parameterName: 'dstmicroservice' },
                { pathName: 'dstapis', parameterName: 'dstapi' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-apiedit-view/dst-apiedit-view.vue'),
    },
    {
        path: '/dstapis/:dstapi?/editview/:editview?',
        meta: {
            caption: 'entities.dstapi.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'dstapis', parameterName: 'dstapi' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-apiedit-view/dst-apiedit-view.vue'),
    },
    {
        path: '/metamodules/:metamodule?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'entities.metamodule.views.pickupgridview.caption',
            info:'',
            parameters: [
                { pathName: 'metamodules', parameterName: 'metamodule' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-module-pickup-grid-view/meta-module-pickup-grid-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/metaentities/:metaentity?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'entities.metaentity.views.pickupgridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-entity-pickup-grid-view/meta-entity-pickup-grid-view.vue'),
    },
    {
        path: '/metaentities/:metaentity?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'entities.metaentity.views.pickupgridview.caption',
            info:'',
            parameters: [
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-entity-pickup-grid-view/meta-entity-pickup-grid-view.vue'),
    },
    {
        path: '/dstdatasources/:dstdatasource?/pickupview/:pickupview?',
        meta: {
            caption: 'entities.dstdatasource.views.pickupview.caption',
            info:'',
            parameters: [
                { pathName: 'dstdatasources', parameterName: 'dstdatasource' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-data-source-pickup-view/dst-data-source-pickup-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/metaentities/:metaentity?/metafields/:metafield?/editview/:editview?',
        meta: {
            caption: 'entities.metafield.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'metafields', parameterName: 'metafield' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-field-edit-view/meta-field-edit-view.vue'),
    },
    {
        path: '/metaentities/:metaentity?/metafields/:metafield?/editview/:editview?',
        meta: {
            caption: 'entities.metafield.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'metafields', parameterName: 'metafield' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-field-edit-view/meta-field-edit-view.vue'),
    },
    {
        path: '/metafields/:metafield?/editview/:editview?',
        meta: {
            caption: 'entities.metafield.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'metafields', parameterName: 'metafield' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-field-edit-view/meta-field-edit-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/dstapps/:dstapp?/dstrouters/:dstrouter?/editview/:editview?',
        meta: {
            caption: 'entities.dstrouter.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'dstapps', parameterName: 'dstapp' },
                { pathName: 'dstrouters', parameterName: 'dstrouter' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-router-edit-view/dst-router-edit-view.vue'),
    },
    {
        path: '/dstapps/:dstapp?/dstrouters/:dstrouter?/editview/:editview?',
        meta: {
            caption: 'entities.dstrouter.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'dstapps', parameterName: 'dstapp' },
                { pathName: 'dstrouters', parameterName: 'dstrouter' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-router-edit-view/dst-router-edit-view.vue'),
    },
    {
        path: '/dstrouters/:dstrouter?/editview/:editview?',
        meta: {
            caption: 'entities.dstrouter.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'dstrouters', parameterName: 'dstrouter' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-router-edit-view/dst-router-edit-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/metaentities/:metaentity?/metafields/:metafield?/editgridview/:editgridview?',
        meta: {
            caption: 'entities.metafield.views.editgridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'metafields', parameterName: 'metafield' },
                { pathName: 'editgridview', parameterName: 'editgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-field-edit-grid-view/meta-field-edit-grid-view.vue'),
    },
    {
        path: '/metaentities/:metaentity?/metafields/:metafield?/editgridview/:editgridview?',
        meta: {
            caption: 'entities.metafield.views.editgridview.caption',
            info:'',
            parameters: [
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'metafields', parameterName: 'metafield' },
                { pathName: 'editgridview', parameterName: 'editgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-field-edit-grid-view/meta-field-edit-grid-view.vue'),
    },
    {
        path: '/metafields/:metafield?/editgridview/:editgridview?',
        meta: {
            caption: 'entities.metafield.views.editgridview.caption',
            info:'',
            parameters: [
                { pathName: 'metafields', parameterName: 'metafield' },
                { pathName: 'editgridview', parameterName: 'editgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-field-edit-grid-view/meta-field-edit-grid-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/dstmicroservices/:dstmicroservice?/editview/:editview?',
        meta: {
            caption: 'entities.dstmicroservice.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'dstmicroservices', parameterName: 'dstmicroservice' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-microservice-edit-view/dst-microservice-edit-view.vue'),
    },
    {
        path: '/dstmicroservices/:dstmicroservice?/editview/:editview?',
        meta: {
            caption: 'entities.dstmicroservice.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'dstmicroservices', parameterName: 'dstmicroservice' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-microservice-edit-view/dst-microservice-edit-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/metaentities/:metaentity?/gridview/:gridview?',
        meta: {
            caption: 'entities.metaentity.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-entity-grid-view/meta-entity-grid-view.vue'),
    },
    {
        path: '/metaentities/:metaentity?/gridview/:gridview?',
        meta: {
            caption: 'entities.metaentity.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-entity-grid-view/meta-entity-grid-view.vue'),
    },
    {
        path: '/dstconfigs/:dstconfig?/editview/:editview?',
        meta: {
            caption: 'entities.dstconfig.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'dstconfigs', parameterName: 'dstconfig' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-config-edit-view/dst-config-edit-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/metaentities/:metaentity?/metarelationships/:metarelationship?/pickupview/:pickupview?',
        meta: {
            caption: 'entities.metarelationship.views.pickupview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'metarelationships', parameterName: 'metarelationship' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-relationship-pickup-view/meta-relationship-pickup-view.vue'),
    },
    {
        path: '/metaentities/:metaentity?/metarelationships/:metarelationship?/pickupview/:pickupview?',
        meta: {
            caption: 'entities.metarelationship.views.pickupview.caption',
            info:'',
            parameters: [
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'metarelationships', parameterName: 'metarelationship' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-relationship-pickup-view/meta-relationship-pickup-view.vue'),
    },
    {
        path: '/metarelationships/:metarelationship?/pickupview/:pickupview?',
        meta: {
            caption: 'entities.metarelationship.views.pickupview.caption',
            info:'',
            parameters: [
                { pathName: 'metarelationships', parameterName: 'metarelationship' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-relationship-pickup-view/meta-relationship-pickup-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/dstapps/:dstapp?/dstrouters/:dstrouter?/gridview/:gridview?',
        meta: {
            caption: 'entities.dstrouter.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'dstapps', parameterName: 'dstapp' },
                { pathName: 'dstrouters', parameterName: 'dstrouter' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-router-grid-view/dst-router-grid-view.vue'),
    },
    {
        path: '/dstapps/:dstapp?/dstrouters/:dstrouter?/gridview/:gridview?',
        meta: {
            caption: 'entities.dstrouter.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstapps', parameterName: 'dstapp' },
                { pathName: 'dstrouters', parameterName: 'dstrouter' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-router-grid-view/dst-router-grid-view.vue'),
    },
    {
        path: '/dstrouters/:dstrouter?/gridview/:gridview?',
        meta: {
            caption: 'entities.dstrouter.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstrouters', parameterName: 'dstrouter' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-router-grid-view/dst-router-grid-view.vue'),
    },
    {
        path: '/dstdatasources/:dstdatasource?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'entities.dstdatasource.views.pickupgridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstdatasources', parameterName: 'dstdatasource' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-data-source-pickup-grid-view/dst-data-source-pickup-grid-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/editview/:editview?',
        meta: {
            caption: 'entities.dstsystem.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-system-edit-view/dst-system-edit-view.vue'),
    },
    {
        path: '/bladevisuals/:bladevisual?/editview/:editview?',
        meta: {
            caption: 'entities.bladevisual.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'bladevisuals', parameterName: 'bladevisual' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/avuedata/blade-visual-edit-view/blade-visual-edit-view.vue'),
    },
    {
        path: '/metamodules/:metamodule?/editview/:editview?',
        meta: {
            caption: 'entities.metamodule.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'metamodules', parameterName: 'metamodule' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-module-edit-view/meta-module-edit-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/metaentities/:metaentity?/metadatasets/:metadataset?/editview/:editview?',
        meta: {
            caption: 'entities.metadataset.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'metadatasets', parameterName: 'metadataset' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-data-set-edit-view/meta-data-set-edit-view.vue'),
    },
    {
        path: '/metaentities/:metaentity?/metadatasets/:metadataset?/editview/:editview?',
        meta: {
            caption: 'entities.metadataset.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'metadatasets', parameterName: 'metadataset' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-data-set-edit-view/meta-data-set-edit-view.vue'),
    },
    {
        path: '/metadatasets/:metadataset?/editview/:editview?',
        meta: {
            caption: 'entities.metadataset.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'metadatasets', parameterName: 'metadataset' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-data-set-edit-view/meta-data-set-edit-view.vue'),
    },
    {
        path: '/metamodules/:metamodule?/pickupview/:pickupview?',
        meta: {
            caption: 'entities.metamodule.views.pickupview.caption',
            info:'',
            parameters: [
                { pathName: 'metamodules', parameterName: 'metamodule' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-module-pickup-view/meta-module-pickup-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/dstmicroservices/:dstmicroservice?/pickupview/:pickupview?',
        meta: {
            caption: 'entities.dstmicroservice.views.pickupview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'dstmicroservices', parameterName: 'dstmicroservice' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-microservice-pickup-view/dst-microservice-pickup-view.vue'),
    },
    {
        path: '/dstmicroservices/:dstmicroservice?/pickupview/:pickupview?',
        meta: {
            caption: 'entities.dstmicroservice.views.pickupview.caption',
            info:'',
            parameters: [
                { pathName: 'dstmicroservices', parameterName: 'dstmicroservice' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-microservice-pickup-view/dst-microservice-pickup-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/metaentities/:metaentity?/metarelationships/:metarelationship?/editgridview/:editgridview?',
        meta: {
            caption: 'entities.metarelationship.views.editgridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'metarelationships', parameterName: 'metarelationship' },
                { pathName: 'editgridview', parameterName: 'editgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-relationship-edit-grid-view/meta-relationship-edit-grid-view.vue'),
    },
    {
        path: '/metaentities/:metaentity?/metarelationships/:metarelationship?/editgridview/:editgridview?',
        meta: {
            caption: 'entities.metarelationship.views.editgridview.caption',
            info:'',
            parameters: [
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'metarelationships', parameterName: 'metarelationship' },
                { pathName: 'editgridview', parameterName: 'editgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-relationship-edit-grid-view/meta-relationship-edit-grid-view.vue'),
    },
    {
        path: '/metarelationships/:metarelationship?/editgridview/:editgridview?',
        meta: {
            caption: 'entities.metarelationship.views.editgridview.caption',
            info:'',
            parameters: [
                { pathName: 'metarelationships', parameterName: 'metarelationship' },
                { pathName: 'editgridview', parameterName: 'editgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-relationship-edit-grid-view/meta-relationship-edit-grid-view.vue'),
    },
    {
        path: '/dstdatasources/:dstdatasource?/gridview/:gridview?',
        meta: {
            caption: 'entities.dstdatasource.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstdatasources', parameterName: 'dstdatasource' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-data-source-grid-view/dst-data-source-grid-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/dstapps/:dstapp?/dstviews/:dstview?/editview/:editview?',
        meta: {
            caption: 'entities.dstview.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'dstapps', parameterName: 'dstapp' },
                { pathName: 'dstviews', parameterName: 'dstview' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-view-edit-view/dst-view-edit-view.vue'),
    },
    {
        path: '/dstapps/:dstapp?/dstviews/:dstview?/editview/:editview?',
        meta: {
            caption: 'entities.dstview.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'dstapps', parameterName: 'dstapp' },
                { pathName: 'dstviews', parameterName: 'dstview' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-view-edit-view/dst-view-edit-view.vue'),
    },
    {
        path: '/dstviews/:dstview?/editview/:editview?',
        meta: {
            caption: 'entities.dstview.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'dstviews', parameterName: 'dstview' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-view-edit-view/dst-view-edit-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/metaentities/:metaentity?/metafields/:metafield?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'entities.metafield.views.pickupgridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'metafields', parameterName: 'metafield' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-field-pickup-grid-view/meta-field-pickup-grid-view.vue'),
    },
    {
        path: '/metaentities/:metaentity?/metafields/:metafield?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'entities.metafield.views.pickupgridview.caption',
            info:'',
            parameters: [
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'metafields', parameterName: 'metafield' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-field-pickup-grid-view/meta-field-pickup-grid-view.vue'),
    },
    {
        path: '/metafields/:metafield?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'entities.metafield.views.pickupgridview.caption',
            info:'',
            parameters: [
                { pathName: 'metafields', parameterName: 'metafield' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-field-pickup-grid-view/meta-field-pickup-grid-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/gridview/:gridview?',
        meta: {
            caption: 'entities.dstsystem.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-system-grid-view/dst-system-grid-view.vue'),
    },
    {
        path: '/metamodules/:metamodule?/gridview/:gridview?',
        meta: {
            caption: 'entities.metamodule.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'metamodules', parameterName: 'metamodule' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/meta-module-grid-view/meta-module-grid-view.vue'),
    },
    {
        path: '/dstsystems/:dstsystem?/dstmicroservices/:dstmicroservice?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'entities.dstmicroservice.views.pickupgridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'dstmicroservices', parameterName: 'dstmicroservice' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-microservice-pickup-grid-view/dst-microservice-pickup-grid-view.vue'),
    },
    {
        path: '/dstmicroservices/:dstmicroservice?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'entities.dstmicroservice.views.pickupgridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstmicroservices', parameterName: 'dstmicroservice' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-microservice-pickup-grid-view/dst-microservice-pickup-grid-view.vue'),
    },
    {
        path: '/dstconfigs/:dstconfig?/gridview/:gridview?',
        meta: {
            caption: 'entities.dstconfig.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'dstconfigs', parameterName: 'dstconfig' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/lite/dst-config-grid-view/dst-config-grid-view.vue'),
    },
        ...globalRoutes,
        {
            path: '/login/:login?',
            name: 'login',
            meta: {  
                caption: '登录',
                viewType: 'login',
                requireAuth: false,
                ignoreAddPage: true,
            },
            beforeEnter: (to: any, from: any, next: any) => {
                router.app.$store.commit('resetRootStateData');
                next();
            },
            component: () => import('@components/login/login.vue'),
        },
        {
            path: '/lock',
            name: 'lock',
            meta: {  
                caption: '锁屏',
                viewType: 'lock',
                requireAuth: false,
                ignoreAddPage: true,
            },
            beforeEnter: (to: any, from: any, next: any) => {
                next();
            },
            component: () => import('@components/app-lock/app-lock.vue'),
        },
        {
            path: '/404',
            component: () => import('@components/404/404.vue')
        },
        {
            path: '/500',
            component: () => import('@components/500/500.vue')
        },
        {
            path: '*',
            redirect: 'liteindex'
        },
    ],
});
// 解决路由跳转路由重复时报错
const originalPush = Router.prototype.push
Router.prototype.push = function push(location: any) {
    let result: any = originalPush.call(this, location);
    return result.catch((err: any) => err);
}
export default router;
