import ViewMessageService from '../view-message-service';
/**
 * 视图消息视图消息服务对象基类
 *
 * @export
 * @class ViewMsgMessageServiceBase
 */
export default class ViewMsgMessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsgMessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsgMessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsgMessageServiceBase
     */
    public initBasicParam(){
        this.id = "3AB22DAD-717A-4ED1-9984-697CB58DCD07";
        this.name = "视图消息";
        this.codename = "ViewMsg";
        this.title = "";
        this.content = "组件";
        this.closeMode = 1;
        this.position = "TOP";
        this.type = "info";
        this.isEnableRemove = true;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsgMessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}