/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'refentityid',
          prop: 'ref_entity_id',
          dataType: 'PICKUP',
          isEditable:true
        },
        {
          name: 'refentityname',
          prop: 'ref_entity_name',
          dataType: 'PICKUPTEXT',
          isEditable:true
        },
        {
          name: 'relationname',
          prop: 'name',
          dataType: 'TEXT',
          isEditable:true
        },
        {
          name: 'codename',
          prop: 'code_name',
          dataType: 'TEXT',
          isEditable:true
        },
        {
          name: 'reltype',
          prop: 'relation_type',
          dataType: 'TEXT',
        },
        {
          name: 'entityid',
          prop: 'entity_id',
          dataType: 'PICKUP',
          isEditable:true
        },
        {
          name: 'entityname',
          prop: 'entity_name',
          dataType: 'PICKUPTEXT',
          isEditable:true
        },
        {
          name: 'nestedname',
          prop: 'nested_name',
          dataType: 'TEXT',
          isEditable:true
        },
        {
          name: 'srfmajortext',
          prop: 'name',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'id',
          dataType: 'TEXT',
        },
        {
          name: 'srfkey',
          prop: 'id',
          dataType: 'TEXT',
          isEditable:true
        },
        {
          name: 'metarelationship',
          prop: 'id',
        },
      {
        name: 'n_entityname_like',
        prop: 'n_entityname_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_codename_like',
        prop: 'n_codename_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_refentityname_like',
        prop: 'n_refentityname_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_nestedname_like',
        prop: 'n_nestedname_like',
        dataType: 'QUERYPARAM'
      },

        {
          name:'size',
          prop:'size',
          dataType: 'QUERYPARAM'
        },
        {
          name:'query',
          prop:'query',
          dataType: 'QUERYPARAM'
        },
        {
          name:'filter',
          prop:'filter',
          dataType: 'QUERYPARAM'
        },
        {
          name:'page',
          prop:'page',
          dataType: 'QUERYPARAM'
        },
        {
          name:'sort',
          prop:'sort',
          dataType: 'QUERYPARAM'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata',
          dataType: 'QUERYPARAM'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}