/**
 * LiteIndex 部件模型
 *
 * @export
 * @class LiteIndexModel
 */
export default class LiteIndexModel {

    /**
     * 菜单项集合
     *
     * @public
     * @type {any[]}
     * @memberof LiteIndexModel
     */
    public items: any[] = [
        {
	id: '4B9A341A-0A50-4997-84D8-16FA43CDED10',
	name: 'menuitem2',
	text: '数据源',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '数据源',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc2',
	resourcetag: '',
	authtag:'web-liteIndex-menuitem2',
},
        {
	id: '5EB1E88B-564C-4F54-89A3-5954D5EE97F0',
	name: 'menuitem13',
	text: '系统',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '系统',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc13',
	resourcetag: '',
	authtag:'web-liteIndex-menuitem13',
},
        {
	id: '65EB3C1E-8D9D-4694-A65F-495137764D2F',
	name: 'menuitem12',
	text: '模块',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '模块',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc12',
	resourcetag: '',
	authtag:'web-liteIndex-menuitem12',
},
        {
	id: '4F6D513C-830B-4920-8D21-C7241EBC417D',
	name: 'menuitem1',
	text: '实体',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc',
	resourcetag: '',
	authtag:'web-liteIndex-menuitem1',
},
        {
	id: 'A9C57D33-0396-4595-AF22-4AB01652C900',
	name: 'menuitem9',
	text: '模型',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '模型',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc9',
	resourcetag: '',
	authtag:'web-liteIndex-menuitem9',
},
        {
	id: '46AB50C7-6CDC-4CA9-ADB8-BB1CE8B2CF4D',
	name: 'menuitem6',
	text: '微服务',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '微服务',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc6',
	resourcetag: '',
	authtag:'web-liteIndex-menuitem6',
},
        {
	id: '2465B8D8-0519-412B-9D34-1F3355FB9EAF',
	name: 'menuitem8',
	text: '接口',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '接口',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc8',
	resourcetag: '',
	authtag:'web-liteIndex-menuitem8',
},
        {
	id: '6FBDA444-19F9-4382-BBED-AE16FB3C7DBE',
	name: 'menuitem5',
	text: '应用',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '应用',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc5',
	resourcetag: '',
	authtag:'web-liteIndex-menuitem5',
},
        {
	id: '72F4E9D3-2443-49F9-85B4-6CC42A268322',
	name: 'menuitem7',
	text: '路由',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '路由',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc7',
	resourcetag: '',
	authtag:'web-liteIndex-menuitem7',
},
        {
	id: 'E7008324-F31D-4CB7-B2E6-F3CE660996B0',
	name: 'menuitem3',
	text: '视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc3',
	resourcetag: '',
	authtag:'web-liteIndex-menuitem3',
},
        {
	id: '7B655FD1-69E0-4A81-9618-87B5F60DCB12',
	name: 'menuitem4',
	text: '组件',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '组件',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc4',
	resourcetag: '',
	authtag:'web-liteIndex-menuitem4',
},
        {
	id: 'D1F510DC-819F-45FA-AF98-55327155B417',
	name: 'menuitem11',
	text: '配置项',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '配置项',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc11',
	resourcetag: '',
	authtag:'web-liteIndex-menuitem11',
},
        {
	id: '8DAB721A-F1FD-42E3-9EC7-C2871C815FF5',
	name: 'menuitem10',
	text: '大屏',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '大屏',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc10',
	resourcetag: '',
	authtag:'web-liteIndex-menuitem10',
},
    ];

	/**
	 * 应用功能集合
	 *
	 * @public
	 * @type {any[]}
	 * @memberof LiteIndexModel
	 */
	public funcs: any[] = [
        {
            appfunctag: 'AppFunc12',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'metamodulegridview',
            deResParameters: [],
            routepath: '/liteindex/:liteindex?/metamodules/:metamodule?/gridview/:gridview?',
            parameters: [
                { pathName: 'metamodules', parameterName: 'metamodule' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'AppFunc7',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'dstroutergridview',
            deResParameters: [],
            routepath: '/liteindex/:liteindex?/dstrouters/:dstrouter?/gridview/:gridview?',
            parameters: [
                { pathName: 'dstrouters', parameterName: 'dstrouter' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'AppFunc5',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'dstappgridview',
            deResParameters: [],
            routepath: '/liteindex/:liteindex?/dstapps/:dstapp?/gridview/:gridview?',
            parameters: [
                { pathName: 'dstapps', parameterName: 'dstapp' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'AppFunc8',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'dstapigridview',
            deResParameters: [],
            routepath: '/liteindex/:liteindex?/dstapis/:dstapi?/gridview/:gridview?',
            parameters: [
                { pathName: 'dstapis', parameterName: 'dstapi' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'AppFunc10',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'bladevisualgridview',
            deResParameters: [],
            routepath: '/liteindex/:liteindex?/bladevisuals/:bladevisual?/gridview/:gridview?',
            parameters: [
                { pathName: 'bladevisuals', parameterName: 'bladevisual' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'AppFunc13',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'dstsystemgridview',
            deResParameters: [],
            routepath: '/liteindex/:liteindex?/dstsystems/:dstsystem?/gridview/:gridview?',
            parameters: [
                { pathName: 'dstsystems', parameterName: 'dstsystem' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'AppFunc9',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'metamodelgridview',
            deResParameters: [],
            routepath: '/liteindex/:liteindex?/metamodels/:metamodel?/gridview/:gridview?',
            parameters: [
                { pathName: 'metamodels', parameterName: 'metamodel' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'AppFunc6',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'dstmicroservicegridview',
            deResParameters: [],
            routepath: '/liteindex/:liteindex?/dstmicroservices/:dstmicroservice?/gridview/:gridview?',
            parameters: [
                { pathName: 'dstmicroservices', parameterName: 'dstmicroservice' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'AppFunc11',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'dstconfiggridview',
            deResParameters: [],
            routepath: '/liteindex/:liteindex?/dstconfigs/:dstconfig?/gridview/:gridview?',
            parameters: [
                { pathName: 'dstconfigs', parameterName: 'dstconfig' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'AppFunc',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'metaentitygridview',
            deResParameters: [],
            routepath: '/liteindex/:liteindex?/metaentities/:metaentity?/gridview/:gridview?',
            parameters: [
                { pathName: 'metaentities', parameterName: 'metaentity' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'AppFunc4',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'dstcomponentgridview',
            deResParameters: [],
            routepath: '/liteindex/:liteindex?/dstcomponents/:dstcomponent?/gridview/:gridview?',
            parameters: [
                { pathName: 'dstcomponents', parameterName: 'dstcomponent' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'AppFunc2',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'dstdatasourcegridview',
            deResParameters: [],
            routepath: '/liteindex/:liteindex?/dstdatasources/:dstdatasource?/gridview/:gridview?',
            parameters: [
                { pathName: 'dstdatasources', parameterName: 'dstdatasource' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'AppFunc3',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'dstviewgridview',
            deResParameters: [],
            routepath: '/liteindex/:liteindex?/dstviews/:dstview?/gridview/:gridview?',
            parameters: [
                { pathName: 'dstviews', parameterName: 'dstview' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
	];

    /**
     * 获取所有菜单项集合
     *
     * @returns {any[]}
     * @memberof LiteIndexModel
     */
    public getAppMenuItems(): any[] {
        return this.items;
    }

    /**
     * 获取所有应用功能集合
     *
     * @returns {any[]}
     * @memberof LiteIndexModel
     */
    public getAppFuncs(): any[] {
        return this.funcs;
    }
}