import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 实体关系服务对象基类
 *
 * @export
 * @class MetaRelationshipServiceBase
 * @extends {EntityServie}
 */
export default class MetaRelationshipServiceBase extends EntityService {

    /**
     * Creates an instance of  MetaRelationshipServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  MetaRelationshipServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof MetaRelationshipServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='metarelationship';
        this.APPDEKEY = 'id';
        this.APPDENAME = 'metarelationships';
        this.APPDETEXT = 'name';
        this.APPNAME = 'web';
        this.SYSTEMNAME = 'ibzlite';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaRelationshipServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && context.metarelationship){
            let res:any = Http.getInstance().get(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metarelationships/${context.metarelationship}/select`,isloading);
            
            return res;
        }
        if(context.metaentity && context.metarelationship){
            let res:any = Http.getInstance().get(`/metaentities/${context.metaentity}/metarelationships/${context.metarelationship}/select`,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().get(`/metarelationships/${context.metarelationship}/select`,isloading);
            
            return res;
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaRelationshipServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metarelationships`,data,isloading);
            
            return res;
        }
        if(context.metaentity && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/metaentities/${context.metaentity}/metarelationships`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/metarelationships`,data,isloading);
        
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaRelationshipServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && context.metarelationship){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metarelationships/${context.metarelationship}`,data,isloading);
            
            return res;
        }
        if(context.metaentity && context.metarelationship){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/metaentities/${context.metaentity}/metarelationships/${context.metarelationship}`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/metarelationships/${context.metarelationship}`,data,isloading);
            
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaRelationshipServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && context.metarelationship){
            let res:any = Http.getInstance().delete(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metarelationships/${context.metarelationship}`,isloading);
            return res;
        }
        if(context.metaentity && context.metarelationship){
            let res:any = Http.getInstance().delete(`/metaentities/${context.metaentity}/metarelationships/${context.metarelationship}`,isloading);
            return res;
        }
            let res:any = Http.getInstance().delete(`/metarelationships/${context.metarelationship}`,isloading);
            return res;
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaRelationshipServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && context.metarelationship){
            let res:any = await Http.getInstance().get(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metarelationships/${context.metarelationship}`,isloading);
            
            return res;
        }
        if(context.metaentity && context.metarelationship){
            let res:any = await Http.getInstance().get(`/metaentities/${context.metaentity}/metarelationships/${context.metarelationship}`,isloading);
            
            return res;
        }
            let res:any = await Http.getInstance().get(`/metarelationships/${context.metarelationship}`,isloading);
            
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaRelationshipServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && true){
            let res:any = await Http.getInstance().get(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metarelationships/getdraft`,isloading);
            res.data.metarelationship = data.metarelationship;
            
            return res;
        }
        if(context.metaentity && true){
            let res:any = await Http.getInstance().get(`/metaentities/${context.metaentity}/metarelationships/getdraft`,isloading);
            res.data.metarelationship = data.metarelationship;
            
            return res;
        }
        let res:any = await  Http.getInstance().get(`/metarelationships/getdraft`,isloading);
        res.data.metarelationship = data.metarelationship;
        
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaRelationshipServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && context.metarelationship){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metarelationships/${context.metarelationship}/checkkey`,data,isloading);
            
            return res;
        }
        if(context.metaentity && context.metarelationship){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/metaentities/${context.metaentity}/metarelationships/${context.metarelationship}/checkkey`,data,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().post(`/metarelationships/${context.metarelationship}/checkkey`,data,isloading);
            return res;
    }

    /**
     * InitModel接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaRelationshipServiceBase
     */
    public async InitModel(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && context.metarelationship){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metarelationships/${context.metarelationship}/initmodel`,data,isloading);
            
            return res;
        }
        if(context.metaentity && context.metarelationship){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/metaentities/${context.metaentity}/metarelationships/${context.metarelationship}/initmodel`,data,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().post(`/metarelationships/${context.metarelationship}/initmodel`,data,isloading);
            return res;
    }

    /**
     * InitModelBatch接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaRelationshipServiceBase
     */
    public async InitModelBatch(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return await Http.getInstance().post(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metarelationships/initmodelbatch`,tempData,isloading);
        }
        if(context.metaentity && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return await Http.getInstance().post(`/metaentities/${context.metaentity}/metarelationships/initmodelbatch`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/metarelationships/initmodelbatch`,tempData,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaRelationshipServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && context.metarelationship){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metarelationships/${context.metarelationship}/save`,data,isloading);
            
            return res;
        }
        if(context.metaentity && context.metarelationship){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/metaentities/${context.metaentity}/metarelationships/${context.metarelationship}/save`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/metarelationships/${context.metarelationship}/save`,data,isloading);
            
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaRelationshipServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            let res:any = Http.getInstance().get(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metarelationships/fetchdefault`,tempData,isloading);
            return res;
        }
        if(context.metaentity && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            let res:any = Http.getInstance().get(`/metaentities/${context.metaentity}/metarelationships/fetchdefault`,tempData,isloading);
            return res;
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/metarelationships/fetchdefault`,tempData,isloading);
        return res;
    }

    /**
     * searchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof MetaRelationshipServiceBase
     */
    public async searchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.metaentity && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return await Http.getInstance().post(`/dstsystems/${context.dstsystem}/metaentities/${context.metaentity}/metarelationships/searchdefault`,tempData,isloading);
        }
        if(context.metaentity && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return await Http.getInstance().post(`/metaentities/${context.metaentity}/metarelationships/searchdefault`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/metarelationships/searchdefault`,tempData,isloading);
    }
}