import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 组件服务对象基类
 *
 * @export
 * @class DstComponentServiceBase
 * @extends {EntityServie}
 */
export default class DstComponentServiceBase extends EntityService {

    /**
     * Creates an instance of  DstComponentServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  DstComponentServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof DstComponentServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='dstcomponent';
        this.APPDEKEY = 'id';
        this.APPDENAME = 'dstcomponents';
        this.APPDETEXT = 'name';
        this.APPNAME = 'web';
        this.SYSTEMNAME = 'ibzlite';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstComponentServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && context.dstcomponent){
            let res:any = Http.getInstance().get(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstcomponents/${context.dstcomponent}/select`,isloading);
            
            return res;
        }
        if(context.dstapp && context.dstcomponent){
            let res:any = Http.getInstance().get(`/dstapps/${context.dstapp}/dstcomponents/${context.dstcomponent}/select`,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().get(`/dstcomponents/${context.dstcomponent}/select`,isloading);
            
            return res;
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstComponentServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstcomponents`,data,isloading);
            
            return res;
        }
        if(context.dstapp && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/dstapps/${context.dstapp}/dstcomponents`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/dstcomponents`,data,isloading);
        
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstComponentServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && context.dstcomponent){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstcomponents/${context.dstcomponent}`,data,isloading);
            
            return res;
        }
        if(context.dstapp && context.dstcomponent){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/dstapps/${context.dstapp}/dstcomponents/${context.dstcomponent}`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/dstcomponents/${context.dstcomponent}`,data,isloading);
            
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstComponentServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && context.dstcomponent){
            let res:any = Http.getInstance().delete(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstcomponents/${context.dstcomponent}`,isloading);
            return res;
        }
        if(context.dstapp && context.dstcomponent){
            let res:any = Http.getInstance().delete(`/dstapps/${context.dstapp}/dstcomponents/${context.dstcomponent}`,isloading);
            return res;
        }
            let res:any = Http.getInstance().delete(`/dstcomponents/${context.dstcomponent}`,isloading);
            return res;
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstComponentServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && context.dstcomponent){
            let res:any = await Http.getInstance().get(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstcomponents/${context.dstcomponent}`,isloading);
            
            return res;
        }
        if(context.dstapp && context.dstcomponent){
            let res:any = await Http.getInstance().get(`/dstapps/${context.dstapp}/dstcomponents/${context.dstcomponent}`,isloading);
            
            return res;
        }
            let res:any = await Http.getInstance().get(`/dstcomponents/${context.dstcomponent}`,isloading);
            
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstComponentServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && true){
            let res:any = await Http.getInstance().get(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstcomponents/getdraft`,isloading);
            res.data.dstcomponent = data.dstcomponent;
            
            return res;
        }
        if(context.dstapp && true){
            let res:any = await Http.getInstance().get(`/dstapps/${context.dstapp}/dstcomponents/getdraft`,isloading);
            res.data.dstcomponent = data.dstcomponent;
            
            return res;
        }
        let res:any = await  Http.getInstance().get(`/dstcomponents/getdraft`,isloading);
        res.data.dstcomponent = data.dstcomponent;
        
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstComponentServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && context.dstcomponent){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstcomponents/${context.dstcomponent}/checkkey`,data,isloading);
            
            return res;
        }
        if(context.dstapp && context.dstcomponent){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstapps/${context.dstapp}/dstcomponents/${context.dstcomponent}/checkkey`,data,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().post(`/dstcomponents/${context.dstcomponent}/checkkey`,data,isloading);
            return res;
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstComponentServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && context.dstcomponent){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstcomponents/${context.dstcomponent}/save`,data,isloading);
            
            return res;
        }
        if(context.dstapp && context.dstcomponent){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstapps/${context.dstapp}/dstcomponents/${context.dstcomponent}/save`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/dstcomponents/${context.dstcomponent}/save`,data,isloading);
            
            return res;
    }

    /**
     * Sync接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstComponentServiceBase
     */
    public async Sync(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && context.dstcomponent){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstcomponents/${context.dstcomponent}/sync`,data,isloading);
            
            return res;
        }
        if(context.dstapp && context.dstcomponent){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstapps/${context.dstapp}/dstcomponents/${context.dstcomponent}/sync`,data,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().post(`/dstcomponents/${context.dstcomponent}/sync`,data,isloading);
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstComponentServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            let res:any = Http.getInstance().get(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstcomponents/fetchdefault`,tempData,isloading);
            return res;
        }
        if(context.dstapp && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            let res:any = Http.getInstance().get(`/dstapps/${context.dstapp}/dstcomponents/fetchdefault`,tempData,isloading);
            return res;
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/dstcomponents/fetchdefault`,tempData,isloading);
        return res;
    }

    /**
     * searchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstComponentServiceBase
     */
    public async searchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return await Http.getInstance().post(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstcomponents/searchdefault`,tempData,isloading);
        }
        if(context.dstapp && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return await Http.getInstance().post(`/dstapps/${context.dstapp}/dstcomponents/searchdefault`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/dstcomponents/searchdefault`,tempData,isloading);
    }
}