/**
 * 实体权限服务注册中心
 *
 * @export
 * @class AuthServiceRegister
 */
export class AuthServiceRegister {

    /**
     * 所有实体权限服务Map
     *
     * @protected
     * @type {*}
     * @memberof AuthServiceRegister
     */
    protected allAuthService: Map<string, () => Promise<any>> = new Map();

    /**
     * 已加载实体权限服务Map缓存
     *
     * @protected
     * @type {Map<string, any>}
     * @memberof AuthServiceRegister
     */
    protected serviceCache: Map<string, any> = new Map();

    /**
     * Creates an instance of AuthServiceRegister.
     * @memberof AuthServiceRegister
     */
    constructor() {
        this.init();
    }

    /**
     * 初始化
     *
     * @protected
     * @memberof AuthServiceRegister
     */
    protected init(): void {
                this.allAuthService.set('dstmicroservice', () => import('@/authservice/dst-microservice/dst-microservice-auth-service'));
        this.allAuthService.set('metafield', () => import('@/authservice/meta-field/meta-field-auth-service'));
        this.allAuthService.set('dstapp', () => import('@/authservice/dst-app/dst-app-auth-service'));
        this.allAuthService.set('dstcomponent', () => import('@/authservice/dst-component/dst-component-auth-service'));
        this.allAuthService.set('metadataset', () => import('@/authservice/meta-data-set/meta-data-set-auth-service'));
        this.allAuthService.set('dstview', () => import('@/authservice/dst-view/dst-view-auth-service'));
        this.allAuthService.set('dstapi', () => import('@/authservice/dst-api/dst-api-auth-service'));
        this.allAuthService.set('dstrouter', () => import('@/authservice/dst-router/dst-router-auth-service'));
        this.allAuthService.set('dstconfig', () => import('@/authservice/dst-config/dst-config-auth-service'));
        this.allAuthService.set('metamodel', () => import('@/authservice/meta-model/meta-model-auth-service'));
        this.allAuthService.set('metamodule', () => import('@/authservice/meta-module/meta-module-auth-service'));
        this.allAuthService.set('dstdatasource', () => import('@/authservice/dst-data-source/dst-data-source-auth-service'));
        this.allAuthService.set('dstsystem', () => import('@/authservice/dst-system/dst-system-auth-service'));
        this.allAuthService.set('metarelationship', () => import('@/authservice/meta-relationship/meta-relationship-auth-service'));
        this.allAuthService.set('bladevisual', () => import('@/authservice/blade-visual/blade-visual-auth-service'));
        this.allAuthService.set('metaentity', () => import('@/authservice/meta-entity/meta-entity-auth-service'));
    }

    /**
     * 加载实体权限服务
     *
     * @protected
     * @param {string} serviceName
     * @returns {Promise<any>}
     * @memberof AuthServiceRegister
     */
    protected async loadService(serviceName: string): Promise<any> {
        const service = this.allAuthService.get(serviceName);
        if (service) {
            return service();
        }
    }

    /**
     * 获取应用实体权限服务
     *
     * @param {string} name
     * @returns {Promise<any>}
     * @memberof AuthServiceRegister
     */
    public async getService(name: string): Promise<any> {
        if (this.serviceCache.has(name)) {
            return this.serviceCache.get(name);
        }
        const authService: any = await this.loadService(name);
        if (authService && authService.default) {
            const instance: any = new authService.default();
            this.serviceCache.set(name, instance);
            return instance;
        }
    }

}
export const authServiceRegister: AuthServiceRegister = new AuthServiceRegister();