package cn.ibizlab.api.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[BladeVisualConfigDTO]
 */
@Data
public class BladeVisualConfigDTO extends DTOBase implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 属性 [ID]
     *
     */
    @JSONField(name = "id")
    @JsonProperty("id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 属性 [VISUAL_ID]
     *
     */
    @JSONField(name = "visualId")
    @JsonProperty("visualId")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long visualid;

    /**
     * 属性 [COMPONENT]
     *
     */
    @JSONField(name = "component")
    @JsonProperty("component")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    private String component;

    /**
     * 属性 [DETAIL]
     *
     */
    @JSONField(name = "detail")
    @JsonProperty("detail")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    private String detail;


    /**
     * 设置 [VISUAL_ID]
     */
    public void setVisualid(Long  visualid){
        this.visualid = visualid ;
        this.modify("visual_id",visualid);
    }

    /**
     * 设置 [COMPONENT]
     */
    public void setComponent(String  component){
        this.component = component ;
        this.modify("component",component);
    }

    /**
     * 设置 [DETAIL]
     */
    public void setDetail(String  detail){
        this.detail = detail ;
        this.modify("detail",detail);
    }


}


