import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 页面服务对象基类
 *
 * @export
 * @class DstViewServiceBase
 * @extends {EntityServie}
 */
export default class DstViewServiceBase extends EntityService {

    /**
     * Creates an instance of  DstViewServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  DstViewServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof DstViewServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='dstview';
        this.APPDEKEY = 'id';
        this.APPDENAME = 'dstviews';
        this.APPDETEXT = 'name';
        this.APPNAME = 'web';
        this.SYSTEMNAME = 'ibzlite';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstViewServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && context.dstview){
            let res:any = Http.getInstance().get(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstviews/${context.dstview}/select`,isloading);
            
            return res;
        }
        if(context.dstapp && context.dstview){
            let res:any = Http.getInstance().get(`/dstapps/${context.dstapp}/dstviews/${context.dstview}/select`,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().get(`/dstviews/${context.dstview}/select`,isloading);
            
            return res;
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstViewServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstviews`,data,isloading);
            
            return res;
        }
        if(context.dstapp && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/dstapps/${context.dstapp}/dstviews`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/dstviews`,data,isloading);
        
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstViewServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && context.dstview){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstviews/${context.dstview}`,data,isloading);
            
            return res;
        }
        if(context.dstapp && context.dstview){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/dstapps/${context.dstapp}/dstviews/${context.dstview}`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/dstviews/${context.dstview}`,data,isloading);
            
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstViewServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && context.dstview){
            let res:any = Http.getInstance().delete(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstviews/${context.dstview}`,isloading);
            return res;
        }
        if(context.dstapp && context.dstview){
            let res:any = Http.getInstance().delete(`/dstapps/${context.dstapp}/dstviews/${context.dstview}`,isloading);
            return res;
        }
            let res:any = Http.getInstance().delete(`/dstviews/${context.dstview}`,isloading);
            return res;
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstViewServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && context.dstview){
            let res:any = await Http.getInstance().get(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstviews/${context.dstview}`,isloading);
            
            return res;
        }
        if(context.dstapp && context.dstview){
            let res:any = await Http.getInstance().get(`/dstapps/${context.dstapp}/dstviews/${context.dstview}`,isloading);
            
            return res;
        }
            let res:any = await Http.getInstance().get(`/dstviews/${context.dstview}`,isloading);
            
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstViewServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && true){
            let res:any = await Http.getInstance().get(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstviews/getdraft`,isloading);
            res.data.dstview = data.dstview;
            
            return res;
        }
        if(context.dstapp && true){
            let res:any = await Http.getInstance().get(`/dstapps/${context.dstapp}/dstviews/getdraft`,isloading);
            res.data.dstview = data.dstview;
            
            return res;
        }
        let res:any = await  Http.getInstance().get(`/dstviews/getdraft`,isloading);
        res.data.dstview = data.dstview;
        
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstViewServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && context.dstview){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstviews/${context.dstview}/checkkey`,data,isloading);
            
            return res;
        }
        if(context.dstapp && context.dstview){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstapps/${context.dstapp}/dstviews/${context.dstview}/checkkey`,data,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().post(`/dstviews/${context.dstview}/checkkey`,data,isloading);
            return res;
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstViewServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && context.dstview){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstviews/${context.dstview}/save`,data,isloading);
            
            return res;
        }
        if(context.dstapp && context.dstview){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstapps/${context.dstapp}/dstviews/${context.dstview}/save`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/dstviews/${context.dstview}/save`,data,isloading);
            
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstViewServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstapp && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            let res:any = Http.getInstance().get(`/dstsystems/${context.dstsystem}/dstapps/${context.dstapp}/dstviews/fetchdefault`,tempData,isloading);
            return res;
        }
        if(context.dstapp && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            let res:any = Http.getInstance().get(`/dstapps/${context.dstapp}/dstviews/fetchdefault`,tempData,isloading);
            return res;
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/dstviews/fetchdefault`,tempData,isloading);
        return res;
    }
}