/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'systemid',
          prop: 'system_id',
          dataType: 'PICKUP',
        },
        {
          name: 'targettype',
          prop: 'target_type',
          dataType: 'TEXT',
        },
        {
          name: 'userid',
          prop: 'user_id',
          dataType: 'TEXT',
        },
        {
          name: 'cfgtype',
          prop: 'cfg_type',
          dataType: 'TEXT',
        },
        {
          name: 'updatedate',
          prop: 'update_date',
          dataType: 'DATETIME',
        },
        {
          name: 'srfmajortext',
          prop: 'cfg_type',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'cfg_id',
          dataType: 'TEXT',
        },
        {
          name: 'srfkey',
          prop: 'cfg_id',
          dataType: 'TEXT',
          isEditable:true
        },
        {
          name: 'dstconfig',
          prop: 'cfg_id',
        },
      {
        name: 'n_cfgtype_eq',
        prop: 'n_cfgtype_eq',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_targettype_eq',
        prop: 'n_targettype_eq',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_systemid_eq',
        prop: 'n_systemid_eq',
        dataType: 'QUERYPARAM'
      },

        {
          name:'size',
          prop:'size',
          dataType: 'QUERYPARAM'
        },
        {
          name:'query',
          prop:'query',
          dataType: 'QUERYPARAM'
        },
        {
          name:'filter',
          prop:'filter',
          dataType: 'QUERYPARAM'
        },
        {
          name:'page',
          prop:'page',
          dataType: 'QUERYPARAM'
        },
        {
          name:'sort',
          prop:'sort',
          dataType: 'QUERYPARAM'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata',
          dataType: 'QUERYPARAM'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}