package cn.ibizlab.api.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.api.dto.*;
import cn.ibizlab.api.mapping.*;
import cn.ibizlab.core.lite.domain.DynamicModelConfig;
import cn.ibizlab.core.lite.service.IDynamicModelConfigService;
import cn.ibizlab.core.lite.filter.DynamicModelConfigSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"动态模型配置" })
@RestController("api-dynamicmodelconfig")
@RequestMapping("")
public class DynamicModelConfigResource {

    @Autowired
    public IDynamicModelConfigService dynamicmodelconfigService;

    @Autowired
    @Lazy
    public DynamicModelConfigMapping dynamicmodelconfigMapping;

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DynamicModelConfig-Create-all')")
    @ApiOperation(value = "新建动态模型配置", tags = {"动态模型配置" },  notes = "新建动态模型配置")
	@RequestMapping(method = RequestMethod.POST, value = "/dynamicmodelconfigs")
    public ResponseEntity<DynamicModelConfigDTO> create(@Validated @RequestBody DynamicModelConfigDTO dynamicmodelconfigdto) {
        DynamicModelConfig domain = dynamicmodelconfigMapping.toDomain(dynamicmodelconfigdto);
		dynamicmodelconfigService.create(domain);
        DynamicModelConfigDTO dto = dynamicmodelconfigMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DynamicModelConfig-Create-all')")
    @ApiOperation(value = "批量新建动态模型配置", tags = {"动态模型配置" },  notes = "批量新建动态模型配置")
	@RequestMapping(method = RequestMethod.POST, value = "/dynamicmodelconfigs/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<DynamicModelConfigDTO> dynamicmodelconfigdtos) {
        dynamicmodelconfigService.createBatch(dynamicmodelconfigMapping.toDomain(dynamicmodelconfigdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DynamicModelConfig-Update-all')")
    @ApiOperation(value = "更新动态模型配置", tags = {"动态模型配置" },  notes = "更新动态模型配置")
	@RequestMapping(method = RequestMethod.PUT, value = "/dynamicmodelconfigs/{dynamicmodelconfig_id}")
    public ResponseEntity<DynamicModelConfigDTO> update(@PathVariable("dynamicmodelconfig_id") String dynamicmodelconfig_id, @RequestBody DynamicModelConfigDTO dynamicmodelconfigdto) {
		DynamicModelConfig domain  = dynamicmodelconfigMapping.toDomain(dynamicmodelconfigdto);
        domain .setConfigid(dynamicmodelconfig_id);
		dynamicmodelconfigService.update(domain );
		DynamicModelConfigDTO dto = dynamicmodelconfigMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DynamicModelConfig-Update-all')")
    @ApiOperation(value = "批量更新动态模型配置", tags = {"动态模型配置" },  notes = "批量更新动态模型配置")
	@RequestMapping(method = RequestMethod.PUT, value = "/dynamicmodelconfigs/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<DynamicModelConfigDTO> dynamicmodelconfigdtos) {
        dynamicmodelconfigService.updateBatch(dynamicmodelconfigMapping.toDomain(dynamicmodelconfigdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DynamicModelConfig-Remove-all')")
    @ApiOperation(value = "删除动态模型配置", tags = {"动态模型配置" },  notes = "删除动态模型配置")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dynamicmodelconfigs/{dynamicmodelconfig_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("dynamicmodelconfig_id") String dynamicmodelconfig_id) {
         return ResponseEntity.status(HttpStatus.OK).body(dynamicmodelconfigService.remove(dynamicmodelconfig_id));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DynamicModelConfig-Remove-all')")
    @ApiOperation(value = "批量删除动态模型配置", tags = {"动态模型配置" },  notes = "批量删除动态模型配置")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dynamicmodelconfigs/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        dynamicmodelconfigService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DynamicModelConfig-Get-all')")
    @ApiOperation(value = "获取动态模型配置", tags = {"动态模型配置" },  notes = "获取动态模型配置")
	@RequestMapping(method = RequestMethod.GET, value = "/dynamicmodelconfigs/{dynamicmodelconfig_id}")
    public ResponseEntity<DynamicModelConfigDTO> get(@PathVariable("dynamicmodelconfig_id") String dynamicmodelconfig_id) {
        DynamicModelConfig domain = dynamicmodelconfigService.get(dynamicmodelconfig_id);
        DynamicModelConfigDTO dto = dynamicmodelconfigMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取动态模型配置草稿", tags = {"动态模型配置" },  notes = "获取动态模型配置草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/dynamicmodelconfigs/getdraft")
    public ResponseEntity<DynamicModelConfigDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(dynamicmodelconfigMapping.toDto(dynamicmodelconfigService.getDraft(new DynamicModelConfig())));
    }

    @ApiOperation(value = "检查动态模型配置", tags = {"动态模型配置" },  notes = "检查动态模型配置")
	@RequestMapping(method = RequestMethod.POST, value = "/dynamicmodelconfigs/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody DynamicModelConfigDTO dynamicmodelconfigdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(dynamicmodelconfigService.checkKey(dynamicmodelconfigMapping.toDomain(dynamicmodelconfigdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DynamicModelConfig-Save-all')")
    @ApiOperation(value = "保存动态模型配置", tags = {"动态模型配置" },  notes = "保存动态模型配置")
	@RequestMapping(method = RequestMethod.POST, value = "/dynamicmodelconfigs/save")
    public ResponseEntity<Boolean> save(@RequestBody DynamicModelConfigDTO dynamicmodelconfigdto) {
        return ResponseEntity.status(HttpStatus.OK).body(dynamicmodelconfigService.save(dynamicmodelconfigMapping.toDomain(dynamicmodelconfigdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DynamicModelConfig-Save-all')")
    @ApiOperation(value = "批量保存动态模型配置", tags = {"动态模型配置" },  notes = "批量保存动态模型配置")
	@RequestMapping(method = RequestMethod.POST, value = "/dynamicmodelconfigs/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<DynamicModelConfigDTO> dynamicmodelconfigdtos) {
        dynamicmodelconfigService.saveBatch(dynamicmodelconfigMapping.toDomain(dynamicmodelconfigdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DynamicModelConfig-searchDefault-all')")
	@ApiOperation(value = "获取数据集", tags = {"动态模型配置" } ,notes = "获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/dynamicmodelconfigs/fetchdefault")
	public ResponseEntity<List<DynamicModelConfigDTO>> fetchDefault(DynamicModelConfigSearchContext context) {
        Page<DynamicModelConfig> domains = dynamicmodelconfigService.searchDefault(context) ;
        List<DynamicModelConfigDTO> list = dynamicmodelconfigMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-DynamicModelConfig-searchDefault-all')")
	@ApiOperation(value = "查询数据集", tags = {"动态模型配置" } ,notes = "查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/dynamicmodelconfigs/searchdefault")
	public ResponseEntity<Page<DynamicModelConfigDTO>> searchDefault(@RequestBody DynamicModelConfigSearchContext context) {
        Page<DynamicModelConfig> domains = dynamicmodelconfigService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(dynamicmodelconfigMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

