package cn.ibizlab.api.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[DstAPIDTO]
 */
@Data
public class DstAPIDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [APIID]
     *
     */
    @JSONField(name = "id")
    @JsonProperty("id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String id;

    /**
     * 属性 [APINAME]
     *
     */
    @JSONField(name = "name")
    @JsonProperty("name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String name;

    /**
     * 属性 [APIPATH]
     *
     */
    @JSONField(name = "path")
    @JsonProperty("path")
    @Size(min = 0, max = 2000, message = "内容长度必须小于等于[2000]")
    private String path;

    /**
     * 属性 [SYSTEMID]
     *
     */
    @JSONField(name = "system_id")
    @JsonProperty("system_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String systemId;

    /**
     * 属性 [MSID]
     *
     */
    @JSONField(name = "ms_id")
    @JsonProperty("ms_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String msId;

    /**
     * 属性 [MSNAME]
     *
     */
    @JSONField(name = "ms_name")
    @JsonProperty("ms_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String msName;

    /**
     * 属性 [SERVICENAME]
     *
     */
    @JSONField(name = "service_name")
    @JsonProperty("service_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String serviceName;


    /**
     * 设置 [APINAME]
     */
    public void setName(String  name){
        this.name = name ;
        this.modify("apiname",name);
    }

    /**
     * 设置 [APIPATH]
     */
    public void setPath(String  path){
        this.path = path ;
        this.modify("apipath",path);
    }

    /**
     * 设置 [SYSTEMID]
     */
    public void setSystemId(String  systemId){
        this.systemId = systemId ;
        this.modify("systemid",systemId);
    }

    /**
     * 设置 [MSID]
     */
    public void setMsId(String  msId){
        this.msId = msId ;
        this.modify("msid",msId);
    }

    /**
     * 设置 [MSNAME]
     */
    public void setMsName(String  msName){
        this.msName = msName ;
        this.modify("msname",msName);
    }


}


