package cn.ibizlab.api.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.api.dto.*;
import cn.ibizlab.api.mapping.*;
import cn.ibizlab.core.lite.domain.DstAPI;
import cn.ibizlab.core.lite.service.IDstAPIService;
import cn.ibizlab.core.lite.filter.DstAPISearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"接口" })
@RestController("api-dstapi")
@RequestMapping("")
public class DstAPIResource {

    @Autowired
    public IDstAPIService dstapiService;

    @Autowired
    @Lazy
    public DstAPIMapping dstapiMapping;

    @ApiOperation(value = "新建接口", tags = {"接口" },  notes = "新建接口")
	@RequestMapping(method = RequestMethod.POST, value = "/dstapis")
    public ResponseEntity<DstAPIDTO> create(@Validated @RequestBody DstAPIDTO dstapidto) {
        DstAPI domain = dstapiMapping.toDomain(dstapidto);
		dstapiService.create(domain);
        DstAPIDTO dto = dstapiMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "批量新建接口", tags = {"接口" },  notes = "批量新建接口")
	@RequestMapping(method = RequestMethod.POST, value = "/dstapis/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<DstAPIDTO> dstapidtos) {
        dstapiService.createBatch(dstapiMapping.toDomain(dstapidtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "更新接口", tags = {"接口" },  notes = "更新接口")
	@RequestMapping(method = RequestMethod.PUT, value = "/dstapis/{dstapi_id}")
    public ResponseEntity<DstAPIDTO> update(@PathVariable("dstapi_id") String dstapi_id, @RequestBody DstAPIDTO dstapidto) {
		DstAPI domain  = dstapiMapping.toDomain(dstapidto);
        domain .setId(dstapi_id);
		dstapiService.update(domain );
		DstAPIDTO dto = dstapiMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "批量更新接口", tags = {"接口" },  notes = "批量更新接口")
	@RequestMapping(method = RequestMethod.PUT, value = "/dstapis/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<DstAPIDTO> dstapidtos) {
        dstapiService.updateBatch(dstapiMapping.toDomain(dstapidtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "删除接口", tags = {"接口" },  notes = "删除接口")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dstapis/{dstapi_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("dstapi_id") String dstapi_id) {
         return ResponseEntity.status(HttpStatus.OK).body(dstapiService.remove(dstapi_id));
    }

    @ApiOperation(value = "批量删除接口", tags = {"接口" },  notes = "批量删除接口")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dstapis/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        dstapiService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "获取接口", tags = {"接口" },  notes = "获取接口")
	@RequestMapping(method = RequestMethod.GET, value = "/dstapis/{dstapi_id}")
    public ResponseEntity<DstAPIDTO> get(@PathVariable("dstapi_id") String dstapi_id) {
        DstAPI domain = dstapiService.get(dstapi_id);
        DstAPIDTO dto = dstapiMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取接口草稿", tags = {"接口" },  notes = "获取接口草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/dstapis/getdraft")
    public ResponseEntity<DstAPIDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(dstapiMapping.toDto(dstapiService.getDraft(new DstAPI())));
    }

    @ApiOperation(value = "检查接口", tags = {"接口" },  notes = "检查接口")
	@RequestMapping(method = RequestMethod.POST, value = "/dstapis/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody DstAPIDTO dstapidto) {
        return  ResponseEntity.status(HttpStatus.OK).body(dstapiService.checkKey(dstapiMapping.toDomain(dstapidto)));
    }

    @ApiOperation(value = "保存接口", tags = {"接口" },  notes = "保存接口")
	@RequestMapping(method = RequestMethod.POST, value = "/dstapis/save")
    public ResponseEntity<Boolean> save(@RequestBody DstAPIDTO dstapidto) {
        return ResponseEntity.status(HttpStatus.OK).body(dstapiService.save(dstapiMapping.toDomain(dstapidto)));
    }

    @ApiOperation(value = "批量保存接口", tags = {"接口" },  notes = "批量保存接口")
	@RequestMapping(method = RequestMethod.POST, value = "/dstapis/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<DstAPIDTO> dstapidtos) {
        dstapiService.saveBatch(dstapiMapping.toDomain(dstapidtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "获取数据集", tags = {"接口" } ,notes = "获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/dstapis/fetchdefault")
	public ResponseEntity<List<DstAPIDTO>> fetchDefault(DstAPISearchContext context) {
        Page<DstAPI> domains = dstapiService.searchDefault(context) ;
        List<DstAPIDTO> list = dstapiMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "查询数据集", tags = {"接口" } ,notes = "查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/dstapis/searchdefault")
	public ResponseEntity<Page<DstAPIDTO>> searchDefault(@RequestBody DstAPISearchContext context) {
        Page<DstAPI> domains = dstapiService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(dstapiMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    @ApiOperation(value = "根据微服务建立接口", tags = {"接口" },  notes = "根据微服务建立接口")
	@RequestMapping(method = RequestMethod.POST, value = "/dstmicroservices/{dstmicroservice_id}/dstapis")
    public ResponseEntity<DstAPIDTO> createByDstMicroservice(@PathVariable("dstmicroservice_id") String dstmicroservice_id, @RequestBody DstAPIDTO dstapidto) {
        DstAPI domain = dstapiMapping.toDomain(dstapidto);
        domain.setMsId(dstmicroservice_id);
		dstapiService.create(domain);
        DstAPIDTO dto = dstapiMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据微服务批量建立接口", tags = {"接口" },  notes = "根据微服务批量建立接口")
	@RequestMapping(method = RequestMethod.POST, value = "/dstmicroservices/{dstmicroservice_id}/dstapis/batch")
    public ResponseEntity<Boolean> createBatchByDstMicroservice(@PathVariable("dstmicroservice_id") String dstmicroservice_id, @RequestBody List<DstAPIDTO> dstapidtos) {
        List<DstAPI> domainlist=dstapiMapping.toDomain(dstapidtos);
        for(DstAPI domain:domainlist){
            domain.setMsId(dstmicroservice_id);
        }
        dstapiService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "根据微服务更新接口", tags = {"接口" },  notes = "根据微服务更新接口")
	@RequestMapping(method = RequestMethod.PUT, value = "/dstmicroservices/{dstmicroservice_id}/dstapis/{dstapi_id}")
    public ResponseEntity<DstAPIDTO> updateByDstMicroservice(@PathVariable("dstmicroservice_id") String dstmicroservice_id, @PathVariable("dstapi_id") String dstapi_id, @RequestBody DstAPIDTO dstapidto) {
        DstAPI domain = dstapiMapping.toDomain(dstapidto);
        domain.setMsId(dstmicroservice_id);
        domain.setId(dstapi_id);
		dstapiService.update(domain);
        DstAPIDTO dto = dstapiMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据微服务批量更新接口", tags = {"接口" },  notes = "根据微服务批量更新接口")
	@RequestMapping(method = RequestMethod.PUT, value = "/dstmicroservices/{dstmicroservice_id}/dstapis/batch")
    public ResponseEntity<Boolean> updateBatchByDstMicroservice(@PathVariable("dstmicroservice_id") String dstmicroservice_id, @RequestBody List<DstAPIDTO> dstapidtos) {
        List<DstAPI> domainlist=dstapiMapping.toDomain(dstapidtos);
        for(DstAPI domain:domainlist){
            domain.setMsId(dstmicroservice_id);
        }
        dstapiService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "根据微服务删除接口", tags = {"接口" },  notes = "根据微服务删除接口")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dstmicroservices/{dstmicroservice_id}/dstapis/{dstapi_id}")
    public ResponseEntity<Boolean> removeByDstMicroservice(@PathVariable("dstmicroservice_id") String dstmicroservice_id, @PathVariable("dstapi_id") String dstapi_id) {
		return ResponseEntity.status(HttpStatus.OK).body(dstapiService.remove(dstapi_id));
    }

    @ApiOperation(value = "根据微服务批量删除接口", tags = {"接口" },  notes = "根据微服务批量删除接口")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dstmicroservices/{dstmicroservice_id}/dstapis/batch")
    public ResponseEntity<Boolean> removeBatchByDstMicroservice(@RequestBody List<String> ids) {
        dstapiService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "根据微服务获取接口", tags = {"接口" },  notes = "根据微服务获取接口")
	@RequestMapping(method = RequestMethod.GET, value = "/dstmicroservices/{dstmicroservice_id}/dstapis/{dstapi_id}")
    public ResponseEntity<DstAPIDTO> getByDstMicroservice(@PathVariable("dstmicroservice_id") String dstmicroservice_id, @PathVariable("dstapi_id") String dstapi_id) {
        DstAPI domain = dstapiService.get(dstapi_id);
        DstAPIDTO dto = dstapiMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据微服务获取接口草稿", tags = {"接口" },  notes = "根据微服务获取接口草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/dstmicroservices/{dstmicroservice_id}/dstapis/getdraft")
    public ResponseEntity<DstAPIDTO> getDraftByDstMicroservice(@PathVariable("dstmicroservice_id") String dstmicroservice_id) {
        DstAPI domain = new DstAPI();
        domain.setMsId(dstmicroservice_id);
        return ResponseEntity.status(HttpStatus.OK).body(dstapiMapping.toDto(dstapiService.getDraft(domain)));
    }

    @ApiOperation(value = "根据微服务检查接口", tags = {"接口" },  notes = "根据微服务检查接口")
	@RequestMapping(method = RequestMethod.POST, value = "/dstmicroservices/{dstmicroservice_id}/dstapis/checkkey")
    public ResponseEntity<Boolean> checkKeyByDstMicroservice(@PathVariable("dstmicroservice_id") String dstmicroservice_id, @RequestBody DstAPIDTO dstapidto) {
        return  ResponseEntity.status(HttpStatus.OK).body(dstapiService.checkKey(dstapiMapping.toDomain(dstapidto)));
    }

    @ApiOperation(value = "根据微服务保存接口", tags = {"接口" },  notes = "根据微服务保存接口")
	@RequestMapping(method = RequestMethod.POST, value = "/dstmicroservices/{dstmicroservice_id}/dstapis/save")
    public ResponseEntity<Boolean> saveByDstMicroservice(@PathVariable("dstmicroservice_id") String dstmicroservice_id, @RequestBody DstAPIDTO dstapidto) {
        DstAPI domain = dstapiMapping.toDomain(dstapidto);
        domain.setMsId(dstmicroservice_id);
        return ResponseEntity.status(HttpStatus.OK).body(dstapiService.save(domain));
    }

    @ApiOperation(value = "根据微服务批量保存接口", tags = {"接口" },  notes = "根据微服务批量保存接口")
	@RequestMapping(method = RequestMethod.POST, value = "/dstmicroservices/{dstmicroservice_id}/dstapis/savebatch")
    public ResponseEntity<Boolean> saveBatchByDstMicroservice(@PathVariable("dstmicroservice_id") String dstmicroservice_id, @RequestBody List<DstAPIDTO> dstapidtos) {
        List<DstAPI> domainlist=dstapiMapping.toDomain(dstapidtos);
        for(DstAPI domain:domainlist){
             domain.setMsId(dstmicroservice_id);
        }
        dstapiService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "根据微服务获取数据集", tags = {"接口" } ,notes = "根据微服务获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/dstmicroservices/{dstmicroservice_id}/dstapis/fetchdefault")
	public ResponseEntity<List<DstAPIDTO>> fetchDstAPIDefaultByDstMicroservice(@PathVariable("dstmicroservice_id") String dstmicroservice_id,DstAPISearchContext context) {
        context.setN_msid_eq(dstmicroservice_id);
        Page<DstAPI> domains = dstapiService.searchDefault(context) ;
        List<DstAPIDTO> list = dstapiMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "根据微服务查询数据集", tags = {"接口" } ,notes = "根据微服务查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/dstmicroservices/{dstmicroservice_id}/dstapis/searchdefault")
	public ResponseEntity<Page<DstAPIDTO>> searchDstAPIDefaultByDstMicroservice(@PathVariable("dstmicroservice_id") String dstmicroservice_id, @RequestBody DstAPISearchContext context) {
        context.setN_msid_eq(dstmicroservice_id);
        Page<DstAPI> domains = dstapiService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(dstapiMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @ApiOperation(value = "根据系统微服务建立接口", tags = {"接口" },  notes = "根据系统微服务建立接口")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/dstmicroservices/{dstmicroservice_id}/dstapis")
    public ResponseEntity<DstAPIDTO> createByDstSystemDstMicroservice(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstmicroservice_id") String dstmicroservice_id, @RequestBody DstAPIDTO dstapidto) {
        DstAPI domain = dstapiMapping.toDomain(dstapidto);
        domain.setMsId(dstmicroservice_id);
		dstapiService.create(domain);
        DstAPIDTO dto = dstapiMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据系统微服务批量建立接口", tags = {"接口" },  notes = "根据系统微服务批量建立接口")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/dstmicroservices/{dstmicroservice_id}/dstapis/batch")
    public ResponseEntity<Boolean> createBatchByDstSystemDstMicroservice(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstmicroservice_id") String dstmicroservice_id, @RequestBody List<DstAPIDTO> dstapidtos) {
        List<DstAPI> domainlist=dstapiMapping.toDomain(dstapidtos);
        for(DstAPI domain:domainlist){
            domain.setMsId(dstmicroservice_id);
        }
        dstapiService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "根据系统微服务更新接口", tags = {"接口" },  notes = "根据系统微服务更新接口")
	@RequestMapping(method = RequestMethod.PUT, value = "/dstsystems/{dstsystem_id}/dstmicroservices/{dstmicroservice_id}/dstapis/{dstapi_id}")
    public ResponseEntity<DstAPIDTO> updateByDstSystemDstMicroservice(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstmicroservice_id") String dstmicroservice_id, @PathVariable("dstapi_id") String dstapi_id, @RequestBody DstAPIDTO dstapidto) {
        DstAPI domain = dstapiMapping.toDomain(dstapidto);
        domain.setMsId(dstmicroservice_id);
        domain.setId(dstapi_id);
		dstapiService.update(domain);
        DstAPIDTO dto = dstapiMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据系统微服务批量更新接口", tags = {"接口" },  notes = "根据系统微服务批量更新接口")
	@RequestMapping(method = RequestMethod.PUT, value = "/dstsystems/{dstsystem_id}/dstmicroservices/{dstmicroservice_id}/dstapis/batch")
    public ResponseEntity<Boolean> updateBatchByDstSystemDstMicroservice(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstmicroservice_id") String dstmicroservice_id, @RequestBody List<DstAPIDTO> dstapidtos) {
        List<DstAPI> domainlist=dstapiMapping.toDomain(dstapidtos);
        for(DstAPI domain:domainlist){
            domain.setMsId(dstmicroservice_id);
        }
        dstapiService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "根据系统微服务删除接口", tags = {"接口" },  notes = "根据系统微服务删除接口")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dstsystems/{dstsystem_id}/dstmicroservices/{dstmicroservice_id}/dstapis/{dstapi_id}")
    public ResponseEntity<Boolean> removeByDstSystemDstMicroservice(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstmicroservice_id") String dstmicroservice_id, @PathVariable("dstapi_id") String dstapi_id) {
		return ResponseEntity.status(HttpStatus.OK).body(dstapiService.remove(dstapi_id));
    }

    @ApiOperation(value = "根据系统微服务批量删除接口", tags = {"接口" },  notes = "根据系统微服务批量删除接口")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dstsystems/{dstsystem_id}/dstmicroservices/{dstmicroservice_id}/dstapis/batch")
    public ResponseEntity<Boolean> removeBatchByDstSystemDstMicroservice(@RequestBody List<String> ids) {
        dstapiService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "根据系统微服务获取接口", tags = {"接口" },  notes = "根据系统微服务获取接口")
	@RequestMapping(method = RequestMethod.GET, value = "/dstsystems/{dstsystem_id}/dstmicroservices/{dstmicroservice_id}/dstapis/{dstapi_id}")
    public ResponseEntity<DstAPIDTO> getByDstSystemDstMicroservice(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstmicroservice_id") String dstmicroservice_id, @PathVariable("dstapi_id") String dstapi_id) {
        DstAPI domain = dstapiService.get(dstapi_id);
        DstAPIDTO dto = dstapiMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据系统微服务获取接口草稿", tags = {"接口" },  notes = "根据系统微服务获取接口草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/dstsystems/{dstsystem_id}/dstmicroservices/{dstmicroservice_id}/dstapis/getdraft")
    public ResponseEntity<DstAPIDTO> getDraftByDstSystemDstMicroservice(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstmicroservice_id") String dstmicroservice_id) {
        DstAPI domain = new DstAPI();
        domain.setMsId(dstmicroservice_id);
        return ResponseEntity.status(HttpStatus.OK).body(dstapiMapping.toDto(dstapiService.getDraft(domain)));
    }

    @ApiOperation(value = "根据系统微服务检查接口", tags = {"接口" },  notes = "根据系统微服务检查接口")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/dstmicroservices/{dstmicroservice_id}/dstapis/checkkey")
    public ResponseEntity<Boolean> checkKeyByDstSystemDstMicroservice(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstmicroservice_id") String dstmicroservice_id, @RequestBody DstAPIDTO dstapidto) {
        return  ResponseEntity.status(HttpStatus.OK).body(dstapiService.checkKey(dstapiMapping.toDomain(dstapidto)));
    }

    @ApiOperation(value = "根据系统微服务保存接口", tags = {"接口" },  notes = "根据系统微服务保存接口")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/dstmicroservices/{dstmicroservice_id}/dstapis/save")
    public ResponseEntity<Boolean> saveByDstSystemDstMicroservice(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstmicroservice_id") String dstmicroservice_id, @RequestBody DstAPIDTO dstapidto) {
        DstAPI domain = dstapiMapping.toDomain(dstapidto);
        domain.setMsId(dstmicroservice_id);
        return ResponseEntity.status(HttpStatus.OK).body(dstapiService.save(domain));
    }

    @ApiOperation(value = "根据系统微服务批量保存接口", tags = {"接口" },  notes = "根据系统微服务批量保存接口")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/dstmicroservices/{dstmicroservice_id}/dstapis/savebatch")
    public ResponseEntity<Boolean> saveBatchByDstSystemDstMicroservice(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstmicroservice_id") String dstmicroservice_id, @RequestBody List<DstAPIDTO> dstapidtos) {
        List<DstAPI> domainlist=dstapiMapping.toDomain(dstapidtos);
        for(DstAPI domain:domainlist){
             domain.setMsId(dstmicroservice_id);
        }
        dstapiService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "根据系统微服务获取数据集", tags = {"接口" } ,notes = "根据系统微服务获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/dstsystems/{dstsystem_id}/dstmicroservices/{dstmicroservice_id}/dstapis/fetchdefault")
	public ResponseEntity<List<DstAPIDTO>> fetchDstAPIDefaultByDstSystemDstMicroservice(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstmicroservice_id") String dstmicroservice_id,DstAPISearchContext context) {
        context.setN_msid_eq(dstmicroservice_id);
        Page<DstAPI> domains = dstapiService.searchDefault(context) ;
        List<DstAPIDTO> list = dstapiMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "根据系统微服务查询数据集", tags = {"接口" } ,notes = "根据系统微服务查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/dstsystems/{dstsystem_id}/dstmicroservices/{dstmicroservice_id}/dstapis/searchdefault")
	public ResponseEntity<Page<DstAPIDTO>> searchDstAPIDefaultByDstSystemDstMicroservice(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("dstmicroservice_id") String dstmicroservice_id, @RequestBody DstAPISearchContext context) {
        context.setN_msid_eq(dstmicroservice_id);
        Page<DstAPI> domains = dstapiService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(dstapiMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}

