package cn.ibizlab.api.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.api.dto.*;
import cn.ibizlab.api.mapping.*;
import cn.ibizlab.core.avuedata.domain.BladeVisualConfig;
import cn.ibizlab.core.avuedata.service.IBladeVisualConfigService;
import cn.ibizlab.core.avuedata.filter.BladeVisualConfigSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"可视化配置表" })
@RestController("api-bladevisualconfig")
@RequestMapping("")
public class BladeVisualConfigResource {

    @Autowired
    public IBladeVisualConfigService bladevisualconfigService;

    @Autowired
    @Lazy
    public BladeVisualConfigMapping bladevisualconfigMapping;

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-BladeVisualConfig-Create-all')")
    @ApiOperation(value = "新建可视化配置表", tags = {"可视化配置表" },  notes = "新建可视化配置表")
	@RequestMapping(method = RequestMethod.POST, value = "/bladevisualconfigs")
    public ResponseEntity<BladeVisualConfigDTO> create(@Validated @RequestBody BladeVisualConfigDTO bladevisualconfigdto) {
        BladeVisualConfig domain = bladevisualconfigMapping.toDomain(bladevisualconfigdto);
		bladevisualconfigService.create(domain);
        BladeVisualConfigDTO dto = bladevisualconfigMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-BladeVisualConfig-Create-all')")
    @ApiOperation(value = "批量新建可视化配置表", tags = {"可视化配置表" },  notes = "批量新建可视化配置表")
	@RequestMapping(method = RequestMethod.POST, value = "/bladevisualconfigs/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<BladeVisualConfigDTO> bladevisualconfigdtos) {
        bladevisualconfigService.createBatch(bladevisualconfigMapping.toDomain(bladevisualconfigdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-BladeVisualConfig-Update-all')")
    @ApiOperation(value = "更新可视化配置表", tags = {"可视化配置表" },  notes = "更新可视化配置表")
	@RequestMapping(method = RequestMethod.PUT, value = "/bladevisualconfigs/{bladevisualconfig_id}")
    public ResponseEntity<BladeVisualConfigDTO> update(@PathVariable("bladevisualconfig_id") Long bladevisualconfig_id, @RequestBody BladeVisualConfigDTO bladevisualconfigdto) {
		BladeVisualConfig domain  = bladevisualconfigMapping.toDomain(bladevisualconfigdto);
        domain .setId(bladevisualconfig_id);
		bladevisualconfigService.update(domain );
		BladeVisualConfigDTO dto = bladevisualconfigMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-BladeVisualConfig-Update-all')")
    @ApiOperation(value = "批量更新可视化配置表", tags = {"可视化配置表" },  notes = "批量更新可视化配置表")
	@RequestMapping(method = RequestMethod.PUT, value = "/bladevisualconfigs/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<BladeVisualConfigDTO> bladevisualconfigdtos) {
        bladevisualconfigService.updateBatch(bladevisualconfigMapping.toDomain(bladevisualconfigdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-BladeVisualConfig-Remove-all')")
    @ApiOperation(value = "删除可视化配置表", tags = {"可视化配置表" },  notes = "删除可视化配置表")
	@RequestMapping(method = RequestMethod.DELETE, value = "/bladevisualconfigs/{bladevisualconfig_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("bladevisualconfig_id") Long bladevisualconfig_id) {
         return ResponseEntity.status(HttpStatus.OK).body(bladevisualconfigService.remove(bladevisualconfig_id));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-BladeVisualConfig-Remove-all')")
    @ApiOperation(value = "批量删除可视化配置表", tags = {"可视化配置表" },  notes = "批量删除可视化配置表")
	@RequestMapping(method = RequestMethod.DELETE, value = "/bladevisualconfigs/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<Long> ids) {
        bladevisualconfigService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-BladeVisualConfig-Get-all')")
    @ApiOperation(value = "获取可视化配置表", tags = {"可视化配置表" },  notes = "获取可视化配置表")
	@RequestMapping(method = RequestMethod.GET, value = "/bladevisualconfigs/{bladevisualconfig_id}")
    public ResponseEntity<BladeVisualConfigDTO> get(@PathVariable("bladevisualconfig_id") Long bladevisualconfig_id) {
        BladeVisualConfig domain = bladevisualconfigService.get(bladevisualconfig_id);
        BladeVisualConfigDTO dto = bladevisualconfigMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取可视化配置表草稿", tags = {"可视化配置表" },  notes = "获取可视化配置表草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/bladevisualconfigs/getdraft")
    public ResponseEntity<BladeVisualConfigDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(bladevisualconfigMapping.toDto(bladevisualconfigService.getDraft(new BladeVisualConfig())));
    }

    @ApiOperation(value = "检查可视化配置表", tags = {"可视化配置表" },  notes = "检查可视化配置表")
	@RequestMapping(method = RequestMethod.POST, value = "/bladevisualconfigs/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody BladeVisualConfigDTO bladevisualconfigdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(bladevisualconfigService.checkKey(bladevisualconfigMapping.toDomain(bladevisualconfigdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-BladeVisualConfig-Save-all')")
    @ApiOperation(value = "保存可视化配置表", tags = {"可视化配置表" },  notes = "保存可视化配置表")
	@RequestMapping(method = RequestMethod.POST, value = "/bladevisualconfigs/save")
    public ResponseEntity<Boolean> save(@RequestBody BladeVisualConfigDTO bladevisualconfigdto) {
        return ResponseEntity.status(HttpStatus.OK).body(bladevisualconfigService.save(bladevisualconfigMapping.toDomain(bladevisualconfigdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-BladeVisualConfig-Save-all')")
    @ApiOperation(value = "批量保存可视化配置表", tags = {"可视化配置表" },  notes = "批量保存可视化配置表")
	@RequestMapping(method = RequestMethod.POST, value = "/bladevisualconfigs/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<BladeVisualConfigDTO> bladevisualconfigdtos) {
        bladevisualconfigService.saveBatch(bladevisualconfigMapping.toDomain(bladevisualconfigdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-BladeVisualConfig-searchDefault-all')")
	@ApiOperation(value = "获取数据集", tags = {"可视化配置表" } ,notes = "获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/bladevisualconfigs/fetchdefault")
	public ResponseEntity<List<BladeVisualConfigDTO>> fetchDefault(BladeVisualConfigSearchContext context) {
        Page<BladeVisualConfig> domains = bladevisualconfigService.searchDefault(context) ;
        List<BladeVisualConfigDTO> list = bladevisualconfigMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-BladeVisualConfig-searchDefault-all')")
	@ApiOperation(value = "查询数据集", tags = {"可视化配置表" } ,notes = "查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/bladevisualconfigs/searchdefault")
	public ResponseEntity<Page<BladeVisualConfigDTO>> searchDefault(@RequestBody BladeVisualConfigSearchContext context) {
        Page<BladeVisualConfig> domains = bladevisualconfigService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(bladevisualconfigMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

