package cn.ibizlab.api.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[MetaDataSetDTO]
 */
@Data
public class MetaDataSetDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [DATASETID]
     *
     */
    @JSONField(name = "dataset_id")
    @JsonProperty("dataset_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String datasetId;

    /**
     * 属性 [DATASETNAME]
     *
     */
    @JSONField(name = "dataset_name")
    @JsonProperty("dataset_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String datasetName;

    /**
     * 属性 [ENTITYID]
     *
     */
    @JSONField(name = "entity_id")
    @JsonProperty("entity_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String entityId;

    /**
     * 属性 [ENTITYNAME]
     *
     */
    @JSONField(name = "entity_name")
    @JsonProperty("entity_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String entityName;

    /**
     * 属性 [CODENAME]
     *
     */
    @JSONField(name = "code_name")
    @JsonProperty("code_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String codeName;

    /**
     * 属性 [DSCODE]
     *
     */
    @JSONField(name = "ds_code")
    @JsonProperty("ds_code")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    private String dsCode;

    /**
     * 属性 [DSMODEL]
     *
     */
    @JSONField(name = "ds_model")
    @JsonProperty("ds_model")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    private String dsModel;


    /**
     * 设置 [DATASETNAME]
     */
    public void setDatasetName(String  datasetName){
        this.datasetName = datasetName ;
        this.modify("datasetname",datasetName);
    }

    /**
     * 设置 [ENTITYID]
     */
    public void setEntityId(String  entityId){
        this.entityId = entityId ;
        this.modify("entityid",entityId);
    }

    /**
     * 设置 [ENTITYNAME]
     */
    public void setEntityName(String  entityName){
        this.entityName = entityName ;
        this.modify("entityname",entityName);
    }

    /**
     * 设置 [CODENAME]
     */
    public void setCodeName(String  codeName){
        this.codeName = codeName ;
        this.modify("codename",codeName);
    }

    /**
     * 设置 [DSCODE]
     */
    public void setDsCode(String  dsCode){
        this.dsCode = dsCode ;
        this.modify("dscode",dsCode);
    }

    /**
     * 设置 [DSMODEL]
     */
    public void setDsModel(String  dsModel){
        this.dsModel = dsModel ;
        this.modify("dsmodel",dsModel);
    }


}


