package cn.ibizlab.api.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[DstMicroserviceDTO]
 */
@Data
public class DstMicroserviceDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [MSID]
     *
     */
    @JSONField(name = "id")
    @JsonProperty("id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String id;

    /**
     * 属性 [MSNAME]
     *
     */
    @JSONField(name = "label")
    @JsonProperty("label")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String label;

    /**
     * 属性 [SERVICENAME]
     *
     */
    @JSONField(name = "servicename")
    @JsonProperty("servicename")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String servicename;

    /**
     * 属性 [SYSTEMID]
     *
     */
    @JSONField(name = "systemid")
    @JsonProperty("systemid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String systemid;

    /**
     * 属性 [ADDR]
     *
     */
    @JSONField(name = "addr")
    @JsonProperty("addr")
    @Size(min = 0, max = 300, message = "内容长度必须小于等于[300]")
    private String addr;


    /**
     * 设置 [MSNAME]
     */
    public void setLabel(String  label){
        this.label = label ;
        this.modify("msname",label);
    }

    /**
     * 设置 [SERVICENAME]
     */
    public void setServicename(String  servicename){
        this.servicename = servicename ;
        this.modify("servicename",servicename);
    }

    /**
     * 设置 [SYSTEMID]
     */
    public void setSystemid(String  systemid){
        this.systemid = systemid ;
        this.modify("systemid",systemid);
    }

    /**
     * 设置 [ADDR]
     */
    public void setAddr(String  addr){
        this.addr = addr ;
        this.modify("addr",addr);
    }


}


