package cn.ibizlab.core.lite.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.lite.domain.DstDataSource;
import cn.ibizlab.core.lite.filter.DstDataSourceSearchContext;
import cn.ibizlab.core.lite.service.IDstDataSourceService;

import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.helper.DEFieldCacheMap;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.ibizlab.core.lite.mapper.DstDataSourceMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

/**
 * 实体[数据源] 服务对象接口实现
 */
@Slf4j
@Service("DstDataSourceServiceImpl")
public class DstDataSourceServiceImpl extends ServiceImpl<DstDataSourceMapper, DstDataSource> implements IDstDataSourceService {

    @Autowired
    @Lazy
    protected cn.ibizlab.core.lite.service.IMetaEntityService metaentityService;

    protected int batchSize = 500;

    @Override
    @Transactional
    public boolean create(DstDataSource et) {
        if(!this.retBool(this.baseMapper.insert(et))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getDsId()), et);
        return true;
    }

    @Override
    @Transactional
    public void createBatch(List<DstDataSource> list) {
        this.saveBatch(list, batchSize);
    }

    @Override
    @Transactional
    public boolean update(DstDataSource et) {
        if(!update(et, (Wrapper) et.getUpdateWrapper(true).eq("dsid", et.getDsId()))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getDsId()), et);
        return true;
    }

    @Override
    @Transactional
    public void updateBatch(List<DstDataSource> list) {
        updateBatchById(list, batchSize);
    }

    @Override
    @Transactional
    public boolean remove(String key) {
        boolean result = removeById(key);
        return result ;
    }

    @Override
    @Transactional
    public void removeBatch(Collection<String> idList) {
        removeByIds(idList);
    }

    @Override
    @Transactional
    public DstDataSource get(String key) {
        DstDataSource et = getById(key);
        if(et == null){
            et = new DstDataSource();
            et.setDsId(key);
        }
        else {
        }
        return et;
    }

    @Override
    public DstDataSource getDraft(DstDataSource et) {
        return et;
    }

    @Override
    @Transactional
    public DstDataSource buildDS(DstDataSource et) {
        //自定义代码
        return et;
    }

    @Override
    @Transactional
    public boolean buildDSBatch(List<DstDataSource> etList) {
        for(DstDataSource et : etList) {
            buildDS(et);
        }
        return true;
    }

    @Override
    public boolean checkKey(DstDataSource et) {
        return (!ObjectUtils.isEmpty(et.getDsId())) && (!Objects.isNull(this.getById(et.getDsId())));
    }
    @Override
    @Transactional
    public DstDataSource initDS(DstDataSource et) {
        //自定义代码
        return et;
    }

    @Override
    @Transactional
    public boolean initDSBatch(List<DstDataSource> etList) {
        for(DstDataSource et : etList) {
            initDS(et);
        }
        return true;
    }

    @Override
    @Transactional
    public boolean save(DstDataSource et) {
        if(!saveOrUpdate(et)) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean saveOrUpdate(DstDataSource et) {
        if (null == et) {
            return false;
        } else {
            return checkKey(et) ? getProxyService().update(et) : getProxyService().create(et);
        }
    }

    @Override
    @Transactional
    public boolean saveBatch(Collection<DstDataSource> list) {
        List<DstDataSource> create = new ArrayList<>();
        List<DstDataSource> update = new ArrayList<>();
        for (DstDataSource et : list) {
            if (ObjectUtils.isEmpty(et.getDsId()) || ObjectUtils.isEmpty(getById(et.getDsId()))) {
                create.add(et);
            } else {
                update.add(et);
            }
        }
        if (create.size() > 0) {
            getProxyService().createBatch(create);
        }
        if (update.size() > 0) {
            getProxyService().updateBatch(update);
        }
        return true;
    }

    @Override
    @Transactional
    public void saveBatch(List<DstDataSource> list) {
        List<DstDataSource> create = new ArrayList<>();
        List<DstDataSource> update = new ArrayList<>();
        for (DstDataSource et : list) {
            if (ObjectUtils.isEmpty(et.getDsId()) || ObjectUtils.isEmpty(getById(et.getDsId()))) {
                create.add(et);
            } else {
                update.add(et);
            }
        }
        if (create.size() > 0) {
            getProxyService().createBatch(create);
        }
        if (update.size() > 0) {
            getProxyService().updateBatch(update);
        }
    }



    /**
     * 查询集合 数据集
     */
    @Override
    public Page<DstDataSource> searchDefault(DstDataSourceSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<DstDataSource> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<DstDataSource>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }







    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }






    public IDstDataSourceService getProxyService() {
        return cn.ibizlab.util.security.SpringContextHolder.getBean(this.getClass());
    }
}



