package cn.ibizlab.core.lite.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.lite.domain.DstAPI;
import cn.ibizlab.core.lite.filter.DstAPISearchContext;
import cn.ibizlab.core.lite.service.IDstAPIService;

import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.helper.DEFieldCacheMap;


/**
 * 实体[接口] 无存储服务对象接口实现
 */
@Slf4j
@Service
public class DstAPIServiceImpl implements IDstAPIService {


    @Override
    public boolean create(DstAPI et) {
        //代码实现
        return true;
    }

    public void createBatch(List<DstAPI> list){
    }

    @Override
    public boolean update(DstAPI et) {
        //代码实现
        return true;
    }

    public void updateBatch(List<DstAPI> list){
    }

    @Override
    public boolean remove(String key) {
        return true;
    }

    public void removeBatch(Collection<String> idList){
    }

    @Override
    public DstAPI get(String key) {
        DstAPI et = new DstAPI();
        et.setId(key);
        return et;
    }

    @Override
    public DstAPI getDraft(DstAPI et) {
        return et;
    }

    @Override
    public boolean checkKey(DstAPI et) {
        return false;
    }
    @Override
    @Transactional
    public boolean save(DstAPI et) {
        //代码实现
        return true;
    }

    @Override
    public void saveBatch(List<DstAPI> list) {
    }



	@Override
    public List<DstAPI> selectByMsId(String id) {
        return null;
    }

    @Override
    public void removeByMsId(String id) {
        Set<String> delIds=new HashSet<String>();
        for(DstAPI before:selectByMsId(id)){
            delIds.add(before.getId());
        }
        if(delIds.size()>0)
            this.removeBatch(delIds);
    }

	@Override
    public List<DstAPI> selectBySystemId(String pssystemid) {
        return null;
    }

    @Override
    public void removeBySystemId(String pssystemid) {
        Set<String> delIds=new HashSet<String>();
        for(DstAPI before:selectBySystemId(pssystemid)){
            delIds.add(before.getId());
        }
        if(delIds.size()>0)
            this.removeBatch(delIds);
    }



    /**
     * 查询集合 数据集
     */
    @Override
    public Page<DstAPI> searchDefault(DstAPISearchContext context) {
        return new PageImpl<DstAPI>(new ArrayList(),context.getPageable(),0);
    }


}


