package cn.ibizlab.core.lite.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.lite.domain.MetaModule;
import cn.ibizlab.core.lite.filter.MetaModuleSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[MetaModule] 服务对象接口
 */
public interface IMetaModuleService extends IService<MetaModule> {

    boolean create(MetaModule et);
    void createBatch(List<MetaModule> list);
    boolean update(MetaModule et);
    void updateBatch(List<MetaModule> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    MetaModule get(String key);
    MetaModule getDraft(MetaModule et);
    boolean checkKey(MetaModule et);
    boolean save(MetaModule et);
    void saveBatch(List<MetaModule> list);
    Page<MetaModule> searchDefault(MetaModuleSearchContext context);
    List<MetaModule> selectBySystemId(String pssystemid);
    void removeBySystemId(String pssystemid);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

}


