package cn.ibizlab.core.lite.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.lite.domain.MetaLookup;
import cn.ibizlab.core.lite.filter.MetaLookupSearchContext;


/**
 * 实体[MetaLookup] 服务对象接口
 */
public interface IMetaLookupService {

    boolean create(MetaLookup et);
    void createBatch(List<MetaLookup> list);
    boolean update(MetaLookup et);
    void updateBatch(List<MetaLookup> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    MetaLookup get(String key);
    MetaLookup getDraft(MetaLookup et);
    boolean checkKey(MetaLookup et);
    boolean save(MetaLookup et);
    void saveBatch(List<MetaLookup> list);
    Page<MetaLookup> searchDefault(MetaLookupSearchContext context);
    List<MetaLookup> selectByRelationid(String id);
    void removeByRelationid(String id);
    void saveByRelationid(String id, List<MetaLookup> list) ;

}



