package cn.ibizlab.core.lite.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.lite.domain.DynamicModelConfig;
import cn.ibizlab.core.lite.filter.DynamicModelConfigSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[DynamicModelConfig] 服务对象接口
 */
public interface IDynamicModelConfigService extends IService<DynamicModelConfig> {

    boolean create(DynamicModelConfig et);
    void createBatch(List<DynamicModelConfig> list);
    boolean update(DynamicModelConfig et);
    void updateBatch(List<DynamicModelConfig> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    DynamicModelConfig get(String key);
    DynamicModelConfig getDraft(DynamicModelConfig et);
    boolean checkKey(DynamicModelConfig et);
    boolean save(DynamicModelConfig et);
    void saveBatch(List<DynamicModelConfig> list);
    Page<DynamicModelConfig> searchDefault(DynamicModelConfigSearchContext context);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

}


