package cn.ibizlab.core.lite.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.lite.domain.DstComponent;
import cn.ibizlab.core.lite.filter.DstComponentSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[DstComponent] 服务对象接口
 */
public interface IDstComponentService extends IService<DstComponent> {

    boolean create(DstComponent et);
    void createBatch(List<DstComponent> list);
    boolean update(DstComponent et);
    void updateBatch(List<DstComponent> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    DstComponent get(String key);
    DstComponent getDraft(DstComponent et);
    boolean checkKey(DstComponent et);
    boolean save(DstComponent et);
    void saveBatch(List<DstComponent> list);
    DstComponent sync(DstComponent et);
    boolean syncBatch(List<DstComponent> etList);
    Page<DstComponent> searchDefault(DstComponentSearchContext context);
    List<DstComponent> selectByAppId(String id);
    void removeByAppId(String id);
    List<DstComponent> selectBySystemId(String pssystemid);
    void removeBySystemId(String pssystemid);
    List<DstComponent> selectByEntityId(String entity_id);
    void removeByEntityId(String entity_id);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

}


