package cn.ibizlab.core.lite.mapper;

import java.util.List;
import org.apache.ibatis.annotations.*;
import java.util.Map;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import java.util.HashMap;
import org.apache.ibatis.annotations.Select;
import cn.ibizlab.core.lite.domain.MetaModel;
import cn.ibizlab.core.lite.filter.MetaModelSearchContext;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import java.io.Serializable;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.alibaba.fastjson.JSONObject;

public interface MetaModelMapper extends BaseMapper<MetaModel> {

    Page<MetaModel> searchDefault(IPage page, @Param("srf") MetaModelSearchContext context, @Param("ew") Wrapper<MetaModel> wrapper);
    @Override
    @Cacheable(value ="metamodel", key = "'row:'+#p0")
    MetaModel selectById(Serializable id);
    @Override
    @CacheEvict(value ="metamodel", key = "'row:'+#p0.id")
    int insert(MetaModel entity);
    @Override
    @CacheEvict(value ="metamodel", key = "'row:'+#p0.id")
    int updateById(@Param(Constants.ENTITY) MetaModel entity);
    @Override
    @CacheEvict(value ="metamodel", key = "'row:'+#p0.id")
    int update(@Param(Constants.ENTITY) MetaModel entity, @Param("ew") Wrapper<MetaModel> updateWrapper);
    @Override
    @CacheEvict(value ="metamodel", key = "'row:'+#p0")
    int deleteById(Serializable id);
    /**
    * 自定义查询SQL
    * @param sql
    * @return
    */
    @Select("${sql}")
    List<JSONObject> selectBySQL(@Param("sql") String sql, @Param("et")Map param);

    /**
    * 自定义更新SQL
    * @param sql
    * @return
    */
    @Update("${sql}")
    boolean updateBySQL(@Param("sql") String sql, @Param("et")Map param);

    /**
    * 自定义插入SQL
    * @param sql
    * @return
    */
    @Insert("${sql}")
    boolean insertBySQL(@Param("sql") String sql, @Param("et")Map param);

    /**
    * 自定义删除SQL
    * @param sql
    * @return
    */
    @Delete("${sql}")
    boolean deleteBySQL(@Param("sql") String sql, @Param("et")Map param);

    List<MetaModel> selectBySystemId(@Param("pssystemid") Serializable pssystemid);

}
