package cn.ibizlab.core.lite.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.lite.domain.MetaRelationship;
/**
 * 关系型数据实体[MetaRelationship] 查询条件对象
 */
@Slf4j
@Data
public class MetaRelationshipSearchContext extends QueryWrapperContext<MetaRelationship> {

	private String n_codename_like;//[代码名称]
	public void setN_codename_like(String n_codename_like) {
        this.n_codename_like = n_codename_like;
        if(!ObjectUtils.isEmpty(this.n_codename_like)){
            this.getSearchCond().like("codename", n_codename_like);
        }
    }
	private String n_entityid_eq;//[实体标识]
	public void setN_entityid_eq(String n_entityid_eq) {
        this.n_entityid_eq = n_entityid_eq;
        if(!ObjectUtils.isEmpty(this.n_entityid_eq)){
            this.getSearchCond().eq("entityid", n_entityid_eq);
        }
    }
	private String n_entityname_eq;//[实体名称]
	public void setN_entityname_eq(String n_entityname_eq) {
        this.n_entityname_eq = n_entityname_eq;
        if(!ObjectUtils.isEmpty(this.n_entityname_eq)){
            this.getSearchCond().eq("entityname", n_entityname_eq);
        }
    }
	private String n_entityname_like;//[实体名称]
	public void setN_entityname_like(String n_entityname_like) {
        this.n_entityname_like = n_entityname_like;
        if(!ObjectUtils.isEmpty(this.n_entityname_like)){
            this.getSearchCond().like("entityname", n_entityname_like);
        }
    }
	private String n_refentityid_eq;//[引用实体标识]
	public void setN_refentityid_eq(String n_refentityid_eq) {
        this.n_refentityid_eq = n_refentityid_eq;
        if(!ObjectUtils.isEmpty(this.n_refentityid_eq)){
            this.getSearchCond().eq("refentityid", n_refentityid_eq);
        }
    }
	private String n_refentityname_eq;//[引用实体名称]
	public void setN_refentityname_eq(String n_refentityname_eq) {
        this.n_refentityname_eq = n_refentityname_eq;
        if(!ObjectUtils.isEmpty(this.n_refentityname_eq)){
            this.getSearchCond().eq("refentityname", n_refentityname_eq);
        }
    }
	private String n_refentityname_like;//[引用实体名称]
	public void setN_refentityname_like(String n_refentityname_like) {
        this.n_refentityname_like = n_refentityname_like;
        if(!ObjectUtils.isEmpty(this.n_refentityname_like)){
            this.getSearchCond().like("refentityname", n_refentityname_like);
        }
    }
	private String n_nestedname_like;//[嵌套代码名称]
	public void setN_nestedname_like(String n_nestedname_like) {
        this.n_nestedname_like = n_nestedname_like;
        if(!ObjectUtils.isEmpty(this.n_nestedname_like)){
            this.getSearchCond().like("nestedname", n_nestedname_like);
        }
    }
	private String n_systemid_eq;//[系统]
	public void setN_systemid_eq(String n_systemid_eq) {
        this.n_systemid_eq = n_systemid_eq;
        if(!ObjectUtils.isEmpty(this.n_systemid_eq)){
            this.getSearchCond().eq("systemid", n_systemid_eq);
        }
    }

    /**
	 * 启用快速搜索
	 */
    @Override
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("relationname", query)
            );
		 }
	}
}



