package cn.ibizlab.core.lite.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.lite.domain.DstRouter;
/**
 * 关系型数据实体[DstRouter] 查询条件对象
 */
@Slf4j
@Data
public class DstRouterSearchContext extends QueryWrapperContext<DstRouter> {

	private String n_routername_like;//[路径名称]
	public void setN_routername_like(String n_routername_like) {
        this.n_routername_like = n_routername_like;
        if(!ObjectUtils.isEmpty(this.n_routername_like)){
            this.getSearchCond().like("routername", n_routername_like);
        }
    }
	private String n_systemid_eq;//[系统标识]
	public void setN_systemid_eq(String n_systemid_eq) {
        this.n_systemid_eq = n_systemid_eq;
        if(!ObjectUtils.isEmpty(this.n_systemid_eq)){
            this.getSearchCond().eq("systemid", n_systemid_eq);
        }
    }
	private String n_appid_eq;//[应用标识]
	public void setN_appid_eq(String n_appid_eq) {
        this.n_appid_eq = n_appid_eq;
        if(!ObjectUtils.isEmpty(this.n_appid_eq)){
            this.getSearchCond().eq("appid", n_appid_eq);
        }
    }
	private String n_routerpath_like;//[路径]
	public void setN_routerpath_like(String n_routerpath_like) {
        this.n_routerpath_like = n_routerpath_like;
        if(!ObjectUtils.isEmpty(this.n_routerpath_like)){
            this.getSearchCond().like("routerpath", n_routerpath_like);
        }
    }
	private String n_parentid_eq;//[父路径标识]
	public void setN_parentid_eq(String n_parentid_eq) {
        this.n_parentid_eq = n_parentid_eq;
        if(!ObjectUtils.isEmpty(this.n_parentid_eq)){
            this.getSearchCond().eq("parentid", n_parentid_eq);
        }
    }
	private String n_component_like;//[组件]
	public void setN_component_like(String n_component_like) {
        this.n_component_like = n_component_like;
        if(!ObjectUtils.isEmpty(this.n_component_like)){
            this.getSearchCond().like("component", n_component_like);
        }
    }

    /**
	 * 启用快速搜索
	 */
    @Override
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("routername", query)
            );
		 }
	}
}



