package cn.ibizlab.core.lite.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.lite.domain.DstConfig;
/**
 * 关系型数据实体[DstConfig] 查询条件对象
 */
@Slf4j
@Data
public class DstConfigSearchContext extends QueryWrapperContext<DstConfig> {

	private String n_systemid_eq;//[系统标识]
	public void setN_systemid_eq(String n_systemid_eq) {
        this.n_systemid_eq = n_systemid_eq;
        if(!ObjectUtils.isEmpty(this.n_systemid_eq)){
            this.getSearchCond().eq("systemid", n_systemid_eq);
        }
    }
	private String n_cfgtype_eq;//[配置类型]
	public void setN_cfgtype_eq(String n_cfgtype_eq) {
        this.n_cfgtype_eq = n_cfgtype_eq;
        if(!ObjectUtils.isEmpty(this.n_cfgtype_eq)){
            this.getSearchCond().eq("cfgtype", n_cfgtype_eq);
        }
    }
	private String n_cfgtype_like;//[配置类型]
	public void setN_cfgtype_like(String n_cfgtype_like) {
        this.n_cfgtype_like = n_cfgtype_like;
        if(!ObjectUtils.isEmpty(this.n_cfgtype_like)){
            this.getSearchCond().like("cfgtype", n_cfgtype_like);
        }
    }
	private String n_targettype_eq;//[引用类型]
	public void setN_targettype_eq(String n_targettype_eq) {
        this.n_targettype_eq = n_targettype_eq;
        if(!ObjectUtils.isEmpty(this.n_targettype_eq)){
            this.getSearchCond().eq("targettype", n_targettype_eq);
        }
    }
	private String n_userid_eq;//[用户标识]
	public void setN_userid_eq(String n_userid_eq) {
        this.n_userid_eq = n_userid_eq;
        if(!ObjectUtils.isEmpty(this.n_userid_eq)){
            this.getSearchCond().eq("userid", n_userid_eq);
        }
    }

    /**
	 * 启用快速搜索
	 */
    @Override
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("cfgtype", query)
            );
		 }
	}
}



