package cn.ibizlab.core.lite.extensions.util;

import cn.ibizlab.core.lite.domain.MetaEntity;
import cn.ibizlab.core.lite.extensions.service.LiteModelService;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;

import java.util.HashMap;
import java.util.Map;

public class LiteStorage {

    private static Map<String, MetaEntity> metaEntityStorage= new HashMap<String, MetaEntity>();

    private static Object entityLock=new Object();

    public static Map<String, MetaEntity> putMetaEntity(MetaEntity metaEntity)
    {
        synchronized (entityLock)
        {
            metaEntityStorage.put(metaEntity.getEntityId(),metaEntity);
            metaEntityStorage.put(String.format("%1$s.%2$s",metaEntity.getSystemId(),metaEntity.getEntityName()),metaEntity);
            metaEntityStorage.put(String.format("%1$s.%2$s",metaEntity.getSystemId(),metaEntity.getCodeName()),metaEntity);
            return metaEntityStorage;
        }
    }

    private static LiteModelService service;

    public static void setLiteModelService(LiteModelService service)
    {
        if(LiteStorage.service==null)
            LiteStorage.service=service;
    }

    public static LiteModelService getLiteModelService()
    {
        return service;
    }

    public static MetaEntity getMetaEntity(String name)
    {
        synchronized (entityLock)
        {
            if(metaEntityStorage.containsKey(name))
                return metaEntityStorage.get(name);
            else if(name.contains(".")) {
                String[] args=name.split("[.]");
                String systemId=args[0];
                String code=args[1];
                MetaEntity metaEntity = service.getMetaEntityService().getOne(Wrappers.<MetaEntity>lambdaQuery().and(
                        wrapper ->
                                wrapper.eq(MetaEntity::getSystemId,systemId)).and(
                        wrapper ->
                                wrapper.eq(MetaEntity::getEntityName,code).or().eq(MetaEntity::getCodeName,code))
                        ,false);
                if(metaEntity!=null) {
                    metaEntityStorage.put(metaEntity.getEntityId(),metaEntity);
                    metaEntityStorage.put(String.format("%1$s.%2$s",metaEntity.getSystemId(),metaEntity.getEntityName()),metaEntity);
                    metaEntityStorage.put(String.format("%1$s.%2$s",metaEntity.getSystemId(),metaEntity.getCodeName()),metaEntity);
                    return metaEntity;
                }
            }
            else {
                MetaEntity metaEntity = service.getMetaEntityService().getById(name);
                if(metaEntity!=null) {
                    metaEntityStorage.put(metaEntity.getEntityId(),metaEntity);
                    metaEntityStorage.put(String.format("%1$s.%2$s",metaEntity.getSystemId(),metaEntity.getEntityName()),metaEntity);
                    metaEntityStorage.put(String.format("%1$s.%2$s",metaEntity.getSystemId(),metaEntity.getCodeName()),metaEntity);
                    return metaEntity;
                }
            }
        }
        return null;
    }

    public static void resetMetaEntity(String name)
    {
        MetaEntity metaEntity = getMetaEntity(name);
        if(metaEntity!=null)
        {
            synchronized (entityLock)
            {
                metaEntityStorage.remove(metaEntity.getEntityId());
                metaEntityStorage.remove(String.format("%1$s.%2$s",metaEntity.getSystemId(),metaEntity.getEntityName()));
                metaEntityStorage.remove(String.format("%1$s.%2$s",metaEntity.getSystemId(),metaEntity.getCodeName()));
            }
        }
    }
}
