package cn.ibizlab.core.lite.extensions.domain;

import cn.ibizlab.core.lite.domain.MetaEntity;
import cn.ibizlab.core.lite.domain.MetaField;
import cn.ibizlab.core.lite.domain.MetaRelationship;
import lombok.Data;
import org.springframework.util.DigestUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.*;

@Data
public class SysModel {

    private String systemid;

    private String systemname;

    private List<MetaEntityModel> entities;
    /**
     * 获取实体属性
     * @return
     */
    public Set<MetaField>  getField(){
        Set<MetaField> fields=new HashSet<>();
        this.entities.forEach(entityNode->{
            List<MetaField> deField=entityNode.getFields();
            MetaEntity metaEntity = new MetaEntity();
            metaEntity.setSystemId(entityNode.getSystemId());
            metaEntity.setEntityName(entityNode.getEntityName());
            metaEntity.setCodeName(entityNode.getCodeName());
            if(!ObjectUtils.isEmpty(deField)){

                for(int i=0;i<deField.size();i++)
                {
                    MetaField field=deField.get(i);
                    if(field.getShowOrder()==null)
                        field.setShowOrder(1000+i);
                    String refDEId="";
                    String refFieldId="";
                    String curDEId=DigestUtils.md5DigestAsHex(String.format("%s||%s" ,systemid,entityNode.getEntityName()).getBytes());
                    Object refDEName=field.get("ref_de");
                    String refFieldName=field.getRefFieldName();
                    Object relationCodeName=field.get("relation_codename");
                    Object relationName=field.get("relation_name");
                    field.setEntityId(curDEId);
                    field.setEntity(metaEntity);
                    if( !ObjectUtils.isEmpty(refDEName) && !ObjectUtils.isEmpty(refFieldName)){
                        refDEId=DigestUtils.md5DigestAsHex(String.format("%s||%s" ,systemid,refDEName).getBytes());
                        refFieldId=DigestUtils.md5DigestAsHex(String.format("%s||%s" ,refDEId,refFieldName).getBytes());
                        field.setRefFieldId(refFieldId);
                        MetaField reffield = new MetaField();
                        reffield.setFieldId(refFieldId);
                        reffield.setFieldName(refFieldName);
                        field.setReffield(reffield);
                    }
                    if(!ObjectUtils.isEmpty(curDEId) && !ObjectUtils.isEmpty(refDEId) && !ObjectUtils.isEmpty(relationCodeName)&& !ObjectUtils.isEmpty(relationName)){
                        field.setRelationId(DigestUtils.md5DigestAsHex(String.format("%s||%s||%s" ,refDEId,curDEId,relationCodeName).getBytes()));
                        MetaRelationship ship=new MetaRelationship();
                        ship.setName(relationName.toString());
                        ship.setRefEntityName(refDEName.toString());
                        ship.setCodeName(relationCodeName.toString());
                        field.setRelation(ship);
                    }
                }
                fields.addAll(deField);
            }
            }
        );
        return fields;
    }

    /**
     * 获取实体关系
     * @return
     */
    public Collection<MetaRelationship>  getRelation(){
        Map<String, MetaRelationship>  relations =new HashMap<>();
        this.entities.forEach(entityNode->{
            List<MetaRelationship> parentRelation= entityNode.getParentEntitys();
            List<MetaRelationship> subRelation= entityNode.getSubEntitys();
            if(!ObjectUtils.isEmpty(parentRelation)){
                addToRelations(relations,parentRelation);
            }
            if(!ObjectUtils.isEmpty(subRelation)){
                addToRelations(relations,subRelation);
            }
        });
        return relations.values();
    }

    private void addToRelations(Map<String, MetaRelationship> relations, List<MetaRelationship> entityRelations){
        entityRelations.forEach(entityRelation->{
            entityRelation.setEntityId(DigestUtils.md5DigestAsHex(String.format("%s||%s" ,systemid,entityRelation.getEntityName()).getBytes()));
            entityRelation.setRefEntityId(DigestUtils.md5DigestAsHex(String.format("%s||%s" ,systemid,entityRelation.getRefEntityName()).getBytes()));
            String relationId = entityRelation.getId();
            if( !StringUtils.isEmpty(relationId) &&  !relations.containsKey(relationId)){
                relations.put(relationId,entityRelation);
            }
        });
    }
}
