package cn.ibizlab.core.lite.extensions.domain;

import com.alibaba.fastjson.JSONArray;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.util.StringUtils;

import java.util.List;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class Setting {
    private String property;
    private String value;


    public static String getValue(String configString,String propertyName)
    {
        if(!(StringUtils.isEmpty(configString)))
        {
            List<Setting> settings= JSONArray.parseArray(configString,Setting.class);
            for(Setting setting:settings)
            {
                if(propertyName.equals(setting.getProperty()))
                {
                    return setting.getValue();
                }
            }
        }
        return "";
    }
}
