package cn.ibizlab.core.lite.extensions.domain;

import cn.ibizlab.core.lite.domain.MetaField;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.util.StringUtils;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
public class FieldModel {

    private String columnName;

    private String codeName;

    private String unionName;

    private String showName;

    private String comment;

    private MetaField field;

    private RelationshipModel reference;

    @JsonIgnore
    @JSONField(serialize = false)
    public String getColumnExp()
    {
        if(1==field.getPhysicalField())
        {
            return columnName+" as \""+columnName.toUpperCase()+"\"";
        }
        else if(!StringUtils.isEmpty(field.getExpression()))
        {
            return field.getExpression()+" as \""+columnName.toUpperCase()+"\"";
        }
        return "";
    }

    @JsonIgnore
    @JSONField(serialize = false)
    public boolean isPhysicalField()
    {
        return 1==this.getField().getPhysicalField();
    }

    @JsonIgnore
    @JSONField(serialize = false)
    public boolean isKeyField()
    {
        return 1==this.getField().getKeyField();
    }

    @JsonIgnore
    @JSONField(serialize = false)
    public boolean isLogicValidField()
    {
        return "LOGICVALID".equals(this.getField().getPredefined());
    }

    @JsonIgnore
    @JSONField(serialize = false)
    public boolean isLastModifyField()
    {
        return "UPDATEDATE".equals(this.getField().getPredefined());
    }

    @JsonIgnore
    @JSONField(serialize = false)
    public boolean isUnionKeyField()
    {
        return !StringUtils.isEmpty(this.getField().getUnionKey());
    }


}
