package cn.ibizlab.core.lite.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[实体关系]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "IBZRELATION", resultMap = "MetaRelationshipResultMap")
public class MetaRelationship extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 关系标识
     */
    @DEField(name = "relationid", isKeyField = true)
    @TableId(value = "relationid", type = IdType.ASSIGN_UUID)
    @JSONField(name = "id")
    @JsonProperty("id")
    private String id;
    /**
     * 关系名称
     */
    @DEField(name = "relationname")
    @TableField(value = "relationname")
    @JSONField(name = "name")
    @JsonProperty("name")
    private String name;
    /**
     * 类型
     */
    @DEField(name = "reltype")
    @TableField(value = "reltype")
    @JSONField(name = "relation_type")
    @JsonProperty("relation_type")
    private String relationType;
    /**
     * 代码名称
     */
    @TableField(value = "codename")
    @JSONField(name = "code_name")
    @JsonProperty("code_name")
    private String codeName;
    /**
     * 实体标识
     */
    @TableField(value = "entityid")
    @JSONField(name = "entity_id")
    @JsonProperty("entity_id")
    private String entityId;
    /**
     * 实体名称
     */
    @TableField(value = "entityname")
    @JSONField(name = "entity_name")
    @JsonProperty("entity_name")
    private String entityName;
    /**
     * 引用实体标识
     */
    @TableField(value = "refentityid")
    @JSONField(name = "ref_entity_id")
    @JsonProperty("ref_entity_id")
    private String refEntityId;
    /**
     * 引用实体名称
     */
    @TableField(value = "refentityname")
    @JSONField(name = "ref_entity_name")
    @JsonProperty("ref_entity_name")
    private String refEntityName;
    /**
     * 嵌套代码名称
     */
    @TableField(value = "nestedname")
    @JSONField(name = "nested_name")
    @JsonProperty("nested_name")
    private String nestedName;
    /**
     * 系统
     */
    @TableField(exist = false)
    @JSONField(name = "system_id")
    @JsonProperty("system_id")
    private String systemId;
    /**
     * 创建时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 最后修改时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.core.lite.domain.MetaEntity entity;

    /**
     * 
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.core.lite.domain.MetaEntity reference;


    /**
     * lookup
     */
    @JSONField(name = "lookups")
    @JsonProperty("lookups")
    @TableField(value = "lookup" , typeHandler = cn.ibizlab.core.lite.domain.handlers.MetaLookupTypeHandler.class)
    private List<cn.ibizlab.core.lite.domain.MetaLookup> lookups;

    /**
     * 设置 [lookup]
     */
    public void setLookups(List<cn.ibizlab.core.lite.domain.MetaLookup> lookups) {
        this.lookups = lookups;
        this.modify("lookup", (lookups!=null)?lookups:(new ArrayList()));
    }

    /**
     * 设置 [关系名称]
     */
    public void setName(String name) {
        this.name = name;
        this.modify("relationname", name);
    }

    /**
     * 设置 [类型]
     */
    public void setRelationType(String relationType) {
        this.relationType = relationType;
        this.modify("reltype", relationType);
    }

    /**
     * 设置 [代码名称]
     */
    public void setCodeName(String codeName) {
        this.codeName = codeName;
        this.modify("codename", codeName);
    }

    /**
     * 设置 [实体标识]
     */
    public void setEntityId(String entityId) {
        this.entityId = entityId;
        this.modify("entityid", entityId);
    }

    /**
     * 设置 [实体名称]
     */
    public void setEntityName(String entityName) {
        this.entityName = entityName;
        this.modify("entityname", entityName);
    }

    /**
     * 设置 [引用实体标识]
     */
    public void setRefEntityId(String refEntityId) {
        this.refEntityId = refEntityId;
        this.modify("refentityid", refEntityId);
    }

    /**
     * 设置 [引用实体名称]
     */
    public void setRefEntityName(String refEntityName) {
        this.refEntityName = refEntityName;
        this.modify("refentityname", refEntityName);
    }

    /**
     * 设置 [嵌套代码名称]
     */
    public void setNestedName(String nestedName) {
        this.nestedName = nestedName;
        this.modify("nestedname", nestedName);
    }


    /**
     * 获取 [关系标识]
     */
    public String getId() {
        if(ObjectUtils.isEmpty(id)) {
            id=(String)getDefaultKey(true);
        }
        return id;
    }

    @Override
    public Serializable getDefaultKey(boolean gen) {
        if((!ObjectUtils.isEmpty(this.getEntityId()))&&(!ObjectUtils.isEmpty(this.getRefEntityId()))&&(!ObjectUtils.isEmpty(this.getCodeName())))
            return DigestUtils.md5DigestAsHex(String.format("%s||%s||%s" ,this.getEntityId(),this.getRefEntityId(),this.getCodeName()).getBytes());
        return null;
    }
    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("relationid");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


