package cn.ibizlab.core.lite.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[模块]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "IBZMODULE", resultMap = "MetaModuleResultMap")
public class MetaModule extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 模块标识
     */
    @DEField(name = "moduleid", isKeyField = true)
    @TableId(value = "moduleid", type = IdType.ASSIGN_UUID)
    @JSONField(name = "id")
    @JsonProperty("id")
    private String id;
    /**
     * 模块名称
     */
    @DEField(name = "modulename")
    @TableField(value = "modulename")
    @JSONField(name = "name")
    @JsonProperty("name")
    private String name;
    /**
     * 代码名称
     */
    @TableField(value = "codename")
    @JSONField(name = "code_name")
    @JsonProperty("code_name")
    private String codeName;
    /**
     * 系统标识
     */
    @TableField(value = "systemid")
    @JSONField(name = "system_id")
    @JsonProperty("system_id")
    private String systemId;
    /**
     * 排序
     */
    @TableField(value = "showorder")
    @JSONField(name = "show_order")
    @JsonProperty("show_order")
    private Integer showOrder;

    /**
     * 
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.core.lite.domain.DstSystem system;



    /**
     * 设置 [模块名称]
     */
    public void setName(String name) {
        this.name = name;
        this.modify("modulename", name);
    }

    /**
     * 设置 [代码名称]
     */
    public void setCodeName(String codeName) {
        this.codeName = codeName;
        this.modify("codename", codeName);
    }

    /**
     * 设置 [系统标识]
     */
    public void setSystemId(String systemId) {
        this.systemId = systemId;
        this.modify("systemid", systemId);
    }

    /**
     * 设置 [排序]
     */
    public void setShowOrder(Integer showOrder) {
        this.showOrder = showOrder;
        this.modify("showorder", showOrder);
    }


    /**
     * 获取 [模块标识]
     */
    public String getId() {
        if(ObjectUtils.isEmpty(id)) {
            id=(String)getDefaultKey(true);
        }
        return id;
    }

    @Override
    public Serializable getDefaultKey(boolean gen) {
        if((!ObjectUtils.isEmpty(this.getSystemId()))&&(!ObjectUtils.isEmpty(this.getCodeName())))
            return DigestUtils.md5DigestAsHex(String.format("%s||%s" ,this.getSystemId(),this.getCodeName()).getBytes());
        return null;
    }
    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("moduleid");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


