package cn.ibizlab.core.lite.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[属性]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "IBZFIELD", resultMap = "MetaFieldResultMap")
public class MetaField extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 属性标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "fieldid", type = IdType.ASSIGN_UUID)
    @JSONField(name = "field_id")
    @JsonProperty("field_id")
    private String fieldId;
    /**
     * 属性名称
     */
    @TableField(value = "fieldname")
    @JSONField(name = "field_name")
    @JsonProperty("field_name")
    private String fieldName;
    /**
     * 代码名称
     */
    @TableField(value = "codename")
    @JSONField(name = "code_name")
    @JsonProperty("code_name")
    private String codeName;
    /**
     * 实体标识
     */
    @TableField(value = "entityid")
    @JSONField(name = "entity_id")
    @JsonProperty("entity_id")
    private String entityId;
    /**
     * 实体名称
     */
    @TableField(value = "entityname")
    @JSONField(name = "entity_name")
    @JsonProperty("entity_name")
    private String entityName;
    /**
     * 实体代码名称
     */
    @TableField(exist = false)
    @JSONField(name = "entity_code_name")
    @JsonProperty("entity_code_name")
    private String entityCodeName;
    /**
     * 系统
     */
    @TableField(exist = false)
    @JSONField(name = "system_id")
    @JsonProperty("system_id")
    private String systemId;
    /**
     * 属性逻辑名
     */
    @TableField(value = "fieldlogicname")
    @JSONField(name = "field_logic_name")
    @JsonProperty("field_logic_name")
    private String fieldLogicName;
    /**
     * 属性全路径名称
     */
    @TableField(exist = false)
    @JSONField(name = "field_uni_name")
    @JsonProperty("field_uni_name")
    private String fieldUniName;
    /**
     * 显示名称
     */
    @TableField(exist = false)
    @JSONField(name = "field_show_name")
    @JsonProperty("field_show_name")
    private String fieldShowName;
    /**
     * 引用属性标识
     */
    @TableField(value = "reffieldid")
    @JSONField(name = "ref_field_id")
    @JsonProperty("ref_field_id")
    private String refFieldId;
    /**
     * 引用属性名称
     */
    @TableField(value = "reffieldname")
    @JSONField(name = "ref_field_name")
    @JsonProperty("ref_field_name")
    private String refFieldName;
    /**
     * 引用关系标识
     */
    @TableField(value = "relationid")
    @JSONField(name = "relation_id")
    @JsonProperty("relation_id")
    private String relationId;
    /**
     * 引用关系
     */
    @TableField(value = "relationname")
    @JSONField(name = "relation_name")
    @JsonProperty("relation_name")
    private String relationName;
    /**
     * 引用实体
     */
    @TableField(exist = false)
    @JSONField(name = "ref_entity_name")
    @JsonProperty("ref_entity_name")
    private String refEntityName;
    /**
     * 关系代码
     */
    @TableField(exist = false)
    @JSONField(name = "relation_code_name")
    @JsonProperty("relation_code_name")
    private String relationCodeName;
    /**
     * 主键
     */
    @TableField(value = "keyfield")
    @JSONField(name = "key_field")
    @JsonProperty("key_field")
    private Integer keyField;
    /**
     * 主信息
     */
    @TableField(value = "majorfield")
    @JSONField(name = "major_field")
    @JsonProperty("major_field")
    private Integer majorField;
    /**
     * 联合主键
     */
    @TableField(value = "unionkey")
    @JSONField(name = "union_key")
    @JsonProperty("union_key")
    private String unionKey;
    /**
     * 属性类型
     */
    @TableField(value = "fieldtype")
    @JSONField(name = "field_type")
    @JsonProperty("field_type")
    private String fieldType;
    /**
     * 预定义类型
     */
    @TableField(value = "predefined")
    @JSONField(name = "predefined")
    @JsonProperty("predefined")
    private String predefined;
    /**
     * 数据字典
     */
    @TableField(value = "dict")
    @JSONField(name = "dict")
    @JsonProperty("dict")
    private String dict;
    /**
     * 允许为空
     */
    @TableField(value = "nullable")
    @JSONField(name = "nullable")
    @JsonProperty("nullable")
    private Integer nullable;
    /**
     * 物理属性
     */
    @TableField(value = "physicalfield")
    @JSONField(name = "physical_field")
    @JsonProperty("physical_field")
    private Integer physicalField;
    /**
     * 数据类型
     */
    @TableField(value = "datatype")
    @JSONField(name = "data_type")
    @JsonProperty("data_type")
    private String dataType;
    /**
     * 长度
     */
    @TableField(value = "datalength")
    @JSONField(name = "data_length")
    @JsonProperty("data_length")
    private Integer dataLength;
    /**
     * 精度
     */
    @TableField(value = "datapreci")
    @JSONField(name = "data_preci")
    @JsonProperty("data_preci")
    private Integer dataPreci;
    /**
     * 逻辑表达式
     */
    @TableField(value = "expression")
    @JSONField(name = "expression")
    @JsonProperty("expression")
    private String expression;
    /**
     * 扩展属性
     */
    @DEField(defaultValue = "0")
    @TableField(value = "extensionfield")
    @JSONField(name = "extension_field")
    @JsonProperty("extension_field")
    private Integer extensionField;
    /**
     * 审计
     */
    @TableField(value = "isenableaudit")
    @JSONField(name = "is_enable_audit")
    @JsonProperty("is_enable_audit")
    private Integer isEnableAudit;
    /**
     * 排序
     */
    @TableField(value = "showorder")
    @JSONField(name = "show_order")
    @JsonProperty("show_order")
    private Integer showOrder;
    /**
     * 创建时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 最后修改时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.core.lite.domain.MetaEntity entity;

    /**
     * 
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.core.lite.domain.MetaField reffield;

    /**
     * 
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.core.lite.domain.MetaRelationship relation;



    /**
     * 设置 [属性名称]
     */
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
        this.modify("fieldname", fieldName);
    }

    /**
     * 设置 [代码名称]
     */
    public void setCodeName(String codeName) {
        this.codeName = codeName;
        this.modify("codename", codeName);
    }

    /**
     * 设置 [实体标识]
     */
    public void setEntityId(String entityId) {
        this.entityId = entityId;
        this.modify("entityid", entityId);
    }

    /**
     * 设置 [实体名称]
     */
    public void setEntityName(String entityName) {
        this.entityName = entityName;
        this.modify("entityname", entityName);
    }

    /**
     * 设置 [属性逻辑名]
     */
    public void setFieldLogicName(String fieldLogicName) {
        this.fieldLogicName = fieldLogicName;
        this.modify("fieldlogicname", fieldLogicName);
    }

    /**
     * 设置 [引用属性标识]
     */
    public void setRefFieldId(String refFieldId) {
        this.refFieldId = refFieldId;
        this.modify("reffieldid", refFieldId);
    }

    /**
     * 设置 [引用属性名称]
     */
    public void setRefFieldName(String refFieldName) {
        this.refFieldName = refFieldName;
        this.modify("reffieldname", refFieldName);
    }

    /**
     * 设置 [引用关系标识]
     */
    public void setRelationId(String relationId) {
        this.relationId = relationId;
        this.modify("relationid", relationId);
    }

    /**
     * 设置 [引用关系]
     */
    public void setRelationName(String relationName) {
        this.relationName = relationName;
        this.modify("relationname", relationName);
    }

    /**
     * 设置 [主键]
     */
    public void setKeyField(Integer keyField) {
        this.keyField = keyField;
        this.modify("keyfield", keyField);
    }

    /**
     * 设置 [主信息]
     */
    public void setMajorField(Integer majorField) {
        this.majorField = majorField;
        this.modify("majorfield", majorField);
    }

    /**
     * 设置 [联合主键]
     */
    public void setUnionKey(String unionKey) {
        this.unionKey = unionKey;
        this.modify("unionkey", unionKey);
    }

    /**
     * 设置 [属性类型]
     */
    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
        this.modify("fieldtype", fieldType);
    }

    /**
     * 设置 [预定义类型]
     */
    public void setPredefined(String predefined) {
        this.predefined = predefined;
        this.modify("predefined", predefined);
    }

    /**
     * 设置 [数据字典]
     */
    public void setDict(String dict) {
        this.dict = dict;
        this.modify("dict", dict);
    }

    /**
     * 设置 [允许为空]
     */
    public void setNullable(Integer nullable) {
        this.nullable = nullable;
        this.modify("nullable", nullable);
    }

    /**
     * 设置 [物理属性]
     */
    public void setPhysicalField(Integer physicalField) {
        this.physicalField = physicalField;
        this.modify("physicalfield", physicalField);
    }

    /**
     * 设置 [数据类型]
     */
    public void setDataType(String dataType) {
        this.dataType = dataType;
        this.modify("datatype", dataType);
    }

    /**
     * 设置 [长度]
     */
    public void setDataLength(Integer dataLength) {
        this.dataLength = dataLength;
        this.modify("datalength", dataLength);
    }

    /**
     * 设置 [精度]
     */
    public void setDataPreci(Integer dataPreci) {
        this.dataPreci = dataPreci;
        this.modify("datapreci", dataPreci);
    }

    /**
     * 设置 [逻辑表达式]
     */
    public void setExpression(String expression) {
        this.expression = expression;
        this.modify("expression", expression);
    }

    /**
     * 设置 [扩展属性]
     */
    public void setExtensionField(Integer extensionField) {
        this.extensionField = extensionField;
        this.modify("extensionfield", extensionField);
    }

    /**
     * 设置 [审计]
     */
    public void setIsEnableAudit(Integer isEnableAudit) {
        this.isEnableAudit = isEnableAudit;
        this.modify("isenableaudit", isEnableAudit);
    }

    /**
     * 设置 [排序]
     */
    public void setShowOrder(Integer showOrder) {
        this.showOrder = showOrder;
        this.modify("showorder", showOrder);
    }


    /**
     * 获取 [属性标识]
     */
    public String getFieldId() {
        if(ObjectUtils.isEmpty(fieldId)) {
            fieldId=(String)getDefaultKey(true);
        }
        return fieldId;
    }

    @Override
    public Serializable getDefaultKey(boolean gen) {
        if((!ObjectUtils.isEmpty(this.getEntityId()))&&(!ObjectUtils.isEmpty(this.getFieldName())))
            return DigestUtils.md5DigestAsHex(String.format("%s||%s" ,this.getEntityId(),this.getFieldName()).getBytes());
        return null;
    }
    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("fieldid");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


