package cn.ibizlab.core.lite.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[数据集]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "IBZDATASET", resultMap = "MetaDataSetResultMap")
public class MetaDataSet extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "datasetid", type = IdType.ASSIGN_UUID)
    @JSONField(name = "dataset_id")
    @JsonProperty("dataset_id")
    private String datasetId;
    /**
     * 名称
     */
    @TableField(value = "datasetname")
    @JSONField(name = "dataset_name")
    @JsonProperty("dataset_name")
    private String datasetName;
    /**
     * 实体标识
     */
    @TableField(value = "entityid")
    @JSONField(name = "entity_id")
    @JsonProperty("entity_id")
    private String entityId;
    /**
     * 实体
     */
    @TableField(value = "entityname")
    @JSONField(name = "entity_name")
    @JsonProperty("entity_name")
    private String entityName;
    /**
     * 代码名称
     */
    @TableField(value = "codename")
    @JSONField(name = "code_name")
    @JsonProperty("code_name")
    private String codeName;
    /**
     * 代码
     */
    @TableField(value = "dscode")
    @JSONField(name = "ds_code")
    @JsonProperty("ds_code")
    private String dsCode;
    /**
     * 模型
     */
    @TableField(value = "dsmodel")
    @JSONField(name = "ds_model")
    @JsonProperty("ds_model")
    private String dsModel;

    /**
     * 
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.core.lite.domain.MetaEntity entity;



    /**
     * 设置 [名称]
     */
    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
        this.modify("datasetname", datasetName);
    }

    /**
     * 设置 [实体标识]
     */
    public void setEntityId(String entityId) {
        this.entityId = entityId;
        this.modify("entityid", entityId);
    }

    /**
     * 设置 [实体]
     */
    public void setEntityName(String entityName) {
        this.entityName = entityName;
        this.modify("entityname", entityName);
    }

    /**
     * 设置 [代码名称]
     */
    public void setCodeName(String codeName) {
        this.codeName = codeName;
        this.modify("codename", codeName);
    }

    /**
     * 设置 [代码]
     */
    public void setDsCode(String dsCode) {
        this.dsCode = dsCode;
        this.modify("dscode", dsCode);
    }

    /**
     * 设置 [模型]
     */
    public void setDsModel(String dsModel) {
        this.dsModel = dsModel;
        this.modify("dsmodel", dsModel);
    }


    /**
     * 获取 [标识]
     */
    public String getDatasetId() {
        if(ObjectUtils.isEmpty(datasetId)) {
            datasetId=(String)getDefaultKey(true);
        }
        return datasetId;
    }

    @Override
    public Serializable getDefaultKey(boolean gen) {
        if((!ObjectUtils.isEmpty(this.getEntityId()))&&(!ObjectUtils.isEmpty(this.getCodeName())))
            return DigestUtils.md5DigestAsHex(String.format("%s||%s" ,this.getEntityId(),this.getCodeName()).getBytes());
        return null;
    }
    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("datasetid");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


