package cn.ibizlab.core.lite.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[页面]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "IBZVIEW", resultMap = "DstViewResultMap")
public class DstView extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 标识
     */
    @DEField(name = "viewid", isKeyField = true)
    @TableId(value = "viewid", type = IdType.ASSIGN_UUID)
    @JSONField(name = "id")
    @JsonProperty("id")
    private String id;
    /**
     * 名称
     */
    @DEField(name = "viewname")
    @TableField(value = "viewname")
    @JSONField(name = "name")
    @JsonProperty("name")
    private String name;
    /**
     * 视图路径
     */
    @DEField(name = "viewpath")
    @TableField(value = "viewpath")
    @JSONField(name = "path")
    @JsonProperty("path")
    private String path;
    /**
     * 系统标识
     */
    @TableField(value = "systemid")
    @JSONField(name = "system_id")
    @JsonProperty("system_id")
    private String systemId;
    /**
     * 应用标识
     */
    @TableField(value = "appid")
    @JSONField(name = "app_id")
    @JsonProperty("app_id")
    private String appId;
    /**
     * 实体标识
     */
    @TableField(value = "entityid")
    @JSONField(name = "entity_id")
    @JsonProperty("entity_id")
    private String entityId;
    /**
     * 主实体
     */
    @TableField(exist = false)
    @JSONField(name = "entity_name")
    @JsonProperty("entity_name")
    private String entityName;
    /**
     * 配置
     */
    @DEField(name = "cfg")
    @TableField(value = "cfg")
    @JSONField(name = "config")
    @JsonProperty("config")
    private String config;
    /**
     * 最后修改时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.core.lite.domain.DstApp app;

    /**
     * 
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.core.lite.domain.DstSystem system;

    /**
     * 
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.core.lite.domain.MetaEntity factEntity;



    /**
     * 设置 [名称]
     */
    public void setName(String name) {
        this.name = name;
        this.modify("viewname", name);
    }

    /**
     * 设置 [视图路径]
     */
    public void setPath(String path) {
        this.path = path;
        this.modify("viewpath", path);
    }

    /**
     * 设置 [系统标识]
     */
    public void setSystemId(String systemId) {
        this.systemId = systemId;
        this.modify("systemid", systemId);
    }

    /**
     * 设置 [应用标识]
     */
    public void setAppId(String appId) {
        this.appId = appId;
        this.modify("appid", appId);
    }

    /**
     * 设置 [实体标识]
     */
    public void setEntityId(String entityId) {
        this.entityId = entityId;
        this.modify("entityid", entityId);
    }

    /**
     * 设置 [配置]
     */
    public void setConfig(String config) {
        this.config = config;
        this.modify("cfg", config);
    }


    /**
     * 获取 [标识]
     */
    public String getId() {
        if(ObjectUtils.isEmpty(id)) {
            id=(String)getDefaultKey(true);
        }
        return id;
    }

    @Override
    public Serializable getDefaultKey(boolean gen) {
        if((!ObjectUtils.isEmpty(this.getSystemId()))&&(!ObjectUtils.isEmpty(this.getAppId()))&&(!ObjectUtils.isEmpty(this.getPath())))
            return DigestUtils.md5DigestAsHex(String.format("%s||%s||%s" ,this.getSystemId(),this.getAppId(),this.getPath()).getBytes());
        return null;
    }
    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("viewid");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


