package cn.ibizlab.core.lite.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;

import cn.ibizlab.core.lite.domain.handlers.DstAppTypeHandler;
import cn.ibizlab.core.lite.extensions.domain.SysModel;
import cn.ibizlab.core.lite.extensions.domain.SysStructure;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[系统]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "IBZPSSYSTEM",resultMap = "DstSystemResultMap")
public class DstSystem extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 系统标识
     */
    @DEField(isKeyField=true)
    @TableId(value= "pssystemid",type=IdType.ASSIGN_UUID)
    @JSONField(name = "pssystemid")
    @JsonProperty("pssystemid")
    private String pssystemid;
    /**
     * 系统名称
     */
    @TableField(value = "pssystemname")
    @JSONField(name = "pssystemname")
    @JsonProperty("pssystemname")
    private String pssystemname;
    /**
     * 结构
     */
    @TableField(value = "sysstructure",typeHandler = JacksonTypeHandler.class)
    @JSONField(name = "sysstructure")
    @JsonProperty("sysstructure")
    private SysStructure sysstructure;


    /**
     * 结构
     */
    @TableField(value = "apps",typeHandler = DstAppTypeHandler.class)
    @JSONField(name = "apps")
    @JsonProperty("apps")
    private List<DstApp> apps;
    /**
     * 校验
     */
    @TableField(value = "md5check")
    @JSONField(name = "md5check")
    @JsonProperty("md5check")
    private String md5check;
    /**
     * 排序
     */
    @TableField(value = "showorder")
    @JSONField(name = "showorder")
    @JsonProperty("showorder")
    private Integer showorder;



    /**
     * 设置 [系统名称]
     */
    public void setPssystemname(String pssystemname){
        this.pssystemname = pssystemname ;
        this.modify("pssystemname",pssystemname);
    }

    /**
     * 设置 [结构]
     */
    public void setSysstructure(SysStructure sysstructure){
        this.sysstructure = sysstructure ;
        this.modify("sysstructure",sysstructure);
    }

    /**
     * 设置 [APPS]
     */
    public void setApps(List<DstApp>  apps){
        this.apps = apps ;
        this.modify("apps",apps);
    }

    /**
     * 设置 [校验]
     */
    public void setMd5check(String md5check){
        this.md5check = md5check ;
        this.modify("md5check",md5check);
    }

    /**
     * 设置 [排序]
     */
    public void setShoworder(Integer showorder){
        this.showorder = showorder ;
        this.modify("showorder",showorder);
    }


}


