package cn.ibizlab.core.lite.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[路由]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "IBZROUTER", resultMap = "DstRouterResultMap")
public class DstRouter extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 路径标识
     */
    @DEField(name = "routerid", isKeyField = true)
    @TableId(value = "routerid", type = IdType.ASSIGN_UUID)
    @JSONField(name = "id")
    @JsonProperty("id")
    private String id;
    /**
     * 路径名称
     */
    @DEField(name = "routername")
    @TableField(value = "routername")
    @JSONField(name = "name")
    @JsonProperty("name")
    private String name;
    /**
     * 系统标识
     */
    @TableField(value = "systemid")
    @JSONField(name = "system_id")
    @JsonProperty("system_id")
    private String systemId;
    /**
     * 应用标识
     */
    @TableField(value = "appid")
    @JSONField(name = "app_id")
    @JsonProperty("app_id")
    private String appId;
    /**
     * 路径
     */
    @DEField(name = "routerpath")
    @TableField(value = "routerpath")
    @JSONField(name = "path")
    @JsonProperty("path")
    private String path;
    /**
     * 父路径标识
     */
    @TableField(value = "parentid")
    @JSONField(name = "parentid")
    @JsonProperty("parentid")
    private String parentid;
    /**
     * meta
     */
    @TableField(value = "meta")
    @JSONField(name = "meta")
    @JsonProperty("meta")
    private String meta;
    /**
     * 组件
     */
    @TableField(value = "component")
    @JSONField(name = "component")
    @JsonProperty("component")
    private String component;
    /**
     * 最后修改时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.core.lite.domain.DstApp app;

    /**
     * 
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.core.lite.domain.DstRouter parent;

    /**
     * 
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.core.lite.domain.DstSystem system;



    /**
     * 设置 [路径名称]
     */
    public void setName(String name) {
        this.name = name;
        this.modify("routername", name);
    }

    /**
     * 设置 [系统标识]
     */
    public void setSystemId(String systemId) {
        this.systemId = systemId;
        this.modify("systemid", systemId);
    }

    /**
     * 设置 [应用标识]
     */
    public void setAppId(String appId) {
        this.appId = appId;
        this.modify("appid", appId);
    }

    /**
     * 设置 [路径]
     */
    public void setPath(String path) {
        this.path = path;
        this.modify("routerpath", path);
    }

    /**
     * 设置 [父路径标识]
     */
    public void setParentid(String parentid) {
        this.parentid = parentid;
        this.modify("parentid", parentid);
    }

    /**
     * 设置 [meta]
     */
    public void setMeta(String meta) {
        this.meta = meta;
        this.modify("meta", meta);
    }

    /**
     * 设置 [组件]
     */
    public void setComponent(String component) {
        this.component = component;
        this.modify("component", component);
    }


    /**
     * 获取 [路径标识]
     */
    public String getId() {
        if(ObjectUtils.isEmpty(id)) {
            id=(String)getDefaultKey(true);
        }
        return id;
    }

    @Override
    public Serializable getDefaultKey(boolean gen) {
        if((!ObjectUtils.isEmpty(this.getSystemId()))&&(!ObjectUtils.isEmpty(this.getAppId()))&&(!ObjectUtils.isEmpty(this.getPath())))
            return DigestUtils.md5DigestAsHex(String.format("%s||%s||%s" ,this.getSystemId(),this.getAppId(),this.getPath()).getBytes());
        return null;
    }
    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("routerid");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


